/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.databinding.XMLTypeHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.osoa.sca.ServiceRuntimeException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBTypeHelper
implements XMLTypeHelper {
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String ANYTYPE_NAME = "anyType";
    private static final QName ANYTYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "anyType");

    @Override
    public TypeInfo getTypeInfo(Class javaType, Object logical) {
        QName xmlType = JavaXMLMapper.getXMLType(javaType);
        if (xmlType != null) {
            return new TypeInfo(xmlType, true, null);
        }
        if (javaType.isInterface()) {
            return new TypeInfo(ANYTYPE_QNAME, true, null);
        }
        if (logical instanceof XMLType) {
            xmlType = ((XMLType)logical).getTypeName();
        }
        if (xmlType == null) {
            xmlType = new QName(JAXBContextHelper.jaxbDecapitalize(javaType.getSimpleName()));
        }
        return new TypeInfo(xmlType, false, null);
    }

    public static Map<String, String> generateSchema(JAXBContext context) throws IOException {
        StringResolverImpl resolver = new StringResolverImpl();
        context.generateSchema((SchemaOutputResolver)resolver);
        HashMap<String, String> xsds = new HashMap<String, String>();
        for (Map.Entry<String, StreamResult> xsd : resolver.getResults().entrySet()) {
            xsds.put(xsd.getKey(), xsd.getValue().getWriter().toString());
        }
        return xsds;
    }

    private void generateSchemas(List<XSDefinition> definitions, XSDFactory factory, JAXBContext context) throws IOException {
        DOMResolverImpl resolver = new DOMResolverImpl();
        context.generateSchema((SchemaOutputResolver)resolver);
        Map<String, DOMResult> results = resolver.getResults();
        for (Map.Entry<String, DOMResult> entry : results.entrySet()) {
            XSDefinition definition = factory.createXSDefinition();
            definition.setUnresolved(true);
            definition.setDocument((Document)entry.getValue().getNode());
            definition.setNamespace(entry.getKey());
            URI location = null;
            try {
                location = new URI(entry.getValue().getSystemId());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            definition.setLocation(location);
            definitions.add(definition);
        }
    }

    @Override
    public List<XSDefinition> getSchemaDefinitions(XSDFactory factory, ModelResolver resolver, Interface intf) {
        try {
            JAXBContext context = JAXBContextHelper.createJAXBContext(intf, false);
            ArrayList<XSDefinition> definitions = new ArrayList<XSDefinition>();
            this.generateSchemas(definitions, factory, context);
            return definitions;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public List<XSDefinition> getSchemaDefinitions(XSDFactory factory, ModelResolver resolver, List<DataType> dataTypes) {
        try {
            JAXBContext context = JAXBContextHelper.createJAXBContext(dataTypes);
            ArrayList<XSDefinition> definitions = new ArrayList<XSDefinition>();
            this.generateSchemas(definitions, factory, context);
            return definitions;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringResolverImpl
    extends SchemaOutputResolver {
        private Map<String, StreamResult> results = new HashMap<String, StreamResult>();

        private StringResolverImpl() {
        }

        public Result createOutput(String ns, String file) throws IOException {
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            String sysId = ns + '#' + file;
            result.setSystemId(sysId);
            this.results.put(sysId, result);
            return result;
        }

        public Map<String, StreamResult> getResults() {
            return this.results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DOMResolverImpl
    extends SchemaOutputResolver {
        private Map<String, DOMResult> results = new HashMap<String, DOMResult>();

        private DOMResolverImpl() {
        }

        public Result createOutput(String ns, String file) throws IOException {
            DOMResult result = new DOMResult();
            result.setSystemId("");
            this.results.put(ns, result);
            return result;
        }

        public Map<String, DOMResult> getResults() {
            return this.results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XSDResolver
    implements URIResolver {
        private Map<String, String> xsds;

        public XSDResolver(Map<String, String> xsds) {
            this.xsds = xsds;
        }

        public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
            String xsd = this.xsds.get(schemaLocation);
            if (xsd == null) {
                return null;
            }
            return new InputSource(new StringReader(xsd));
        }
    }
}

