/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextCache;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.databinding.util.LRUCache;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContextHelper {
    private static final JAXBContextCache cache = new JAXBContextCache();

    private JAXBContextHelper() {
    }

    public static JAXBContext createJAXBContext(Class<?> cls) throws JAXBException {
        return cache.getJAXBContext(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext createJAXBContext(TransformationContext tContext, boolean source) throws JAXBException {
        Operation op;
        if (tContext == null) {
            throw new TransformationException("JAXB context is not set for the transformation.");
        }
        Operation operation = op = source ? tContext.getSourceOperation() : tContext.getTargetOperation();
        if (op != null) {
            Operation operation2 = op;
            synchronized (operation2) {
                JAXBContext context = op.getInputType().getMetaData(JAXBContext.class);
                if (context == null) {
                    context = JAXBContextHelper.createJAXBContext(JAXBContextHelper.getDataTypes(op, true));
                    op.getInputType().setMetaData(JAXBContext.class, context);
                }
                return context;
            }
        }
        DataType dataType = source ? tContext.getSourceDataType() : tContext.getTargetDataType();
        return JAXBContextHelper.createJAXBContext(dataType);
    }

    public static JAXBContext createJAXBContext(DataType dataType) throws JAXBException {
        return JAXBContextHelper.createJAXBContext(JAXBContextHelper.findClasses(dataType));
    }

    public static Unmarshaller getUnmarshaller(JAXBContext context) throws JAXBException {
        return cache.getUnmarshaller(context);
    }

    public static void releaseJAXBUnmarshaller(JAXBContext context, Unmarshaller unmarshaller) {
        cache.releaseJAXBUnmarshaller(context, unmarshaller);
    }

    public static Marshaller getMarshaller(JAXBContext context) throws JAXBException {
        return cache.getMarshaller(context);
    }

    public static void releaseJAXBMarshaller(JAXBContext context, Marshaller marshaller) {
        cache.releaseJAXBMarshaller(context, marshaller);
    }

    public static Object createJAXBElement(JAXBContext context, DataType dataType, Object value) {
        Class<Object> type = dataType == null ? value.getClass() : dataType.getPhysical();
        QName name = JAXBDataBinding.ROOT_ELEMENT;
        if (context != null) {
            Object logical;
            Object v0 = logical = dataType == null ? null : dataType.getLogical();
            if (logical instanceof XMLType) {
                XMLType xmlType = logical;
                if (xmlType.isElement()) {
                    name = xmlType.getElementName();
                } else {
                    type = Object.class;
                }
            } else {
                type = Object.class;
            }
        }
        JAXBIntrospector introspector = context.createJAXBIntrospector();
        Object element = null;
        if (value != null && introspector.isElement(value)) {
            element = value;
        }
        if (element == null) {
            element = new JAXBElement(name, type, value);
        }
        return element;
    }

    public static Object createReturnValue(JAXBContext context, DataType dataType, Object value) {
        Class<?> cls = JAXBContextHelper.getJavaType(dataType);
        if (cls == JAXBElement.class) {
            return JAXBContextHelper.createJAXBElement(context, dataType, value);
        }
        if (value instanceof JAXBElement) {
            return ((JAXBElement)value).getValue();
        }
        return value;
    }

    public static JAXBContext createJAXBContext(Class<?>[] classes) throws JAXBException {
        return cache.getJAXBContext(classes);
    }

    public static JAXBContext createJAXBContext(Set<Class<?>> classes) throws JAXBException {
        return cache.getJAXBContext(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext createJAXBContext(Interface intf, boolean useWrapper) throws JAXBException {
        JAXBContextCache jAXBContextCache = cache;
        synchronized (jAXBContextCache) {
            LRUCache<Object, JAXBContext> map = cache.getCache();
            Integer key = new Integer(System.identityHashCode(intf));
            JAXBContext context = (JAXBContext)map.get(key);
            if (context != null) {
                return context;
            }
            List<DataType> dataTypes = JAXBContextHelper.getDataTypes(intf, useWrapper);
            context = JAXBContextHelper.createJAXBContext(dataTypes);
            map.put(key, context);
            return context;
        }
    }

    public static JAXBContext createJAXBContext(List<DataType> dataTypes) throws JAXBException {
        HashSet classes = new HashSet();
        HashSet<Type> visited = new HashSet<Type>();
        for (DataType d : dataTypes) {
            JAXBContextHelper.findClasses(d, classes, visited);
        }
        JAXBContext context = JAXBContextHelper.createJAXBContext(classes);
        return context;
    }

    private static Set<Class<?>> findClasses(DataType d) {
        HashSet classes = new HashSet();
        HashSet<Type> visited = new HashSet<Type>();
        JAXBContextHelper.findClasses(d, classes, visited);
        return classes;
    }

    private static void findClasses(DataType d, Set<Class<?>> classes, Set<Type> visited) {
        if (d == null) {
            return;
        }
        String db = d.getDataBinding();
        if ((JAXBDataBinding.NAME.equals(db) || db != null && db.startsWith("java:") || db == null) && !d.getPhysical().isInterface() && !JAXBElement.class.isAssignableFrom(d.getPhysical())) {
            classes.add(d.getPhysical());
        }
        if (d.getPhysical() != d.getGenericType()) {
            JAXBContextHelper.findClasses(d.getGenericType(), classes, visited);
        }
    }

    private static void findClasses(Type type, Set<Class<?>> classSet, Set<Type> visited) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (visited.contains(type) || type == null) {
                            return;
                        }
                        visited.add(type);
                        if (type instanceof Class) {
                            Class cls = (Class)type;
                            if (!cls.isInterface()) {
                                classSet.add(cls);
                            }
                            return;
                        }
                        if (!(type instanceof ParameterizedType)) break block7;
                        ParameterizedType pType = (ParameterizedType)type;
                        JAXBContextHelper.findClasses(pType.getRawType(), classSet, visited);
                        for (Type t : pType.getActualTypeArguments()) {
                            JAXBContextHelper.findClasses(t, classSet, visited);
                        }
                        break block8;
                    }
                    if (!(type instanceof TypeVariable)) break block9;
                    TypeVariable tv = (TypeVariable)type;
                    for (Type t : tv.getBounds()) {
                        JAXBContextHelper.findClasses(t, classSet, visited);
                    }
                    break block8;
                }
                if (!(type instanceof GenericArrayType)) break block10;
                GenericArrayType gType = (GenericArrayType)type;
                JAXBContextHelper.findClasses(gType, classSet, visited);
                break block8;
            }
            if (!(type instanceof WildcardType)) break block8;
            WildcardType wType = (WildcardType)type;
            for (Type t : wType.getLowerBounds()) {
                JAXBContextHelper.findClasses(t, classSet, visited);
            }
            for (Type t : wType.getUpperBounds()) {
                JAXBContextHelper.findClasses(t, classSet, visited);
            }
        }
    }

    public static JAXBContext createJAXBContext(Interface intf) throws JAXBException {
        return JAXBContextHelper.createJAXBContext(intf, true);
    }

    private static List<DataType> getDataTypes(Interface intf, boolean useWrapper) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (Operation op : intf.getOperations()) {
            JAXBContextHelper.getDataTypes(dataTypes, op, useWrapper);
        }
        return dataTypes;
    }

    private static List<DataType> getDataTypes(Operation op, boolean useWrapper) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        JAXBContextHelper.getDataTypes(dataTypes, op, useWrapper);
        return dataTypes;
    }

    private static void getDataTypes(List<DataType> dataTypes, Operation op, boolean useWrapper) {
        WrapperInfo wrapper = op.getWrapper();
        if (useWrapper && wrapper != null) {
            DataType<XMLType> dt2;
            DataType<XMLType> dt1 = wrapper.getInputWrapperType();
            if (dt1 != null) {
                dataTypes.add(dt1);
            }
            if ((dt2 = wrapper.getOutputWrapperType()) != null) {
                dataTypes.add(dt2);
            }
        }
        for (DataType dt1 : op.getInputType().getLogical()) {
            dataTypes.add(dt1);
        }
        DataType dt2 = op.getOutputType();
        if (dt2 != null) {
            dataTypes.add(dt2);
        }
        for (DataType dt3 : op.getFaultTypes()) {
            DataType dt4 = (DataType)dt3.getLogical();
            if (dt4 == null) continue;
            dataTypes.add(dt4);
        }
    }

    public static Class<?> getJavaType(DataType<?> dataType) {
        XMLType xType;
        Class<?> javaType;
        if (dataType == null) {
            return null;
        }
        Class<?> type = dataType.getPhysical();
        if (JAXBElement.class.isAssignableFrom(type)) {
            Type generic = dataType.getGenericType();
            type = Object.class;
        }
        if (type == Object.class && dataType.getLogical() instanceof XMLType && (javaType = SimpleTypeMapperImpl.getJavaType((xType = (XMLType)dataType.getLogical()).getTypeName())) != null) {
            type = javaType;
        }
        return type;
    }

    public static XMLType getXmlTypeName(Class<?> javaType) {
        XmlType type;
        XmlSchema schema;
        if (javaType.isInterface()) {
            return null;
        }
        String namespace = null;
        String name = null;
        Package pkg = javaType.getPackage();
        if (pkg != null && (schema = pkg.getAnnotation(XmlSchema.class)) != null) {
            namespace = schema.namespace();
        }
        QName elementQName = null;
        QName typeQName = null;
        XmlRootElement rootElement = javaType.getAnnotation(XmlRootElement.class);
        if (rootElement != null) {
            String elementName = rootElement.name();
            String elementNamespace = rootElement.namespace();
            if (elementNamespace.equals("##default")) {
                elementNamespace = namespace;
            }
            if (elementName.equals("##default")) {
                elementName = JAXBContextHelper.jaxbDecapitalize(javaType.getSimpleName());
            }
            elementQName = new QName(elementNamespace, elementName);
        }
        if ((type = javaType.getAnnotation(XmlType.class)) != null) {
            String typeNamespace = type.namespace();
            String typeName = type.name();
            if (typeNamespace.equals("##default")) {
                typeNamespace = namespace;
            }
            if (typeName.equals("##default")) {
                typeName = JAXBContextHelper.jaxbDecapitalize(javaType.getSimpleName());
            }
            typeQName = new QName(typeNamespace, typeName);
        } else {
            XmlEnum xmlEnum = javaType.getAnnotation(XmlEnum.class);
            if (xmlEnum != null) {
                name = JAXBContextHelper.jaxbDecapitalize(javaType.getSimpleName());
                typeQName = new QName(namespace, name);
            }
        }
        if (elementQName == null && typeQName == null) {
            return null;
        }
        return new XMLType(elementQName, typeQName);
    }

    public static String jaxbDecapitalize(String name) {
        int lower = name.length();
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isLowerCase(name.charAt(i))) continue;
            lower = i;
            break;
        }
        int decap = name.length() == 0 ? 0 : (lower == 0 ? 0 : (lower == 1 ? 1 : (lower < name.length() ? lower - 1 : name.length())));
        return name.substring(0, decap).toLowerCase() + name.substring(decap);
    }
}

