/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.javabeans;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.tuscany.sca.databinding.impl.BaseDataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeansDataBinding
extends BaseDataBinding {
    public static final int HEAVY_WEIGHT = 10000;
    public static final String NAME = "java:complexType";

    public JavaBeansDataBinding() {
        super(NAME, Object.class);
    }

    protected JavaBeansDataBinding(String name, Class<?> baseType) {
        super(name, baseType);
    }

    @Override
    public Object copy(Object arg, DataType dataType, Operation operation) {
        if (arg == null) {
            return null;
        }
        Class<?> clazz = arg.getClass();
        if (String.class == clazz || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz)) {
            return arg;
        }
        try {
            if (arg instanceof Serializable) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = this.getObjectOutputStream(bos);
                oos.writeObject(arg);
                oos.close();
                bos.close();
                ClassLoader classLoaderToUse = clazz.getClassLoader();
                if (classLoaderToUse == null) {
                    classLoaderToUse = Thread.currentThread().getContextClassLoader();
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                ObjectInputStream ois = this.getObjectInputStream(bis, classLoaderToUse);
                Object objectCopy = ois.readObject();
                ois.close();
                bis.close();
                return objectCopy;
            }
            throw new IllegalArgumentException("Argument type '" + arg.getClass().getCanonicalName() + "' is not Serializable. " + " Pass-by-value cannot be performed on this argument");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Pass-by-value is not supported for the given object", e);
        }
    }

    protected ObjectOutputStream getObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }

    protected ObjectInputStream getObjectInputStream(InputStream is, final ClassLoader cl) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(is){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(desc.getName(), false, cl);
                }
                catch (ClassNotFoundException e) {
                    try {
                        if (cl != Thread.currentThread().getContextClassLoader()) {
                            return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                        }
                    }
                    catch (ClassNotFoundException e1) {
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        // empty catch block
                    }
                    return super.resolveClass(desc);
                }
            }
        };
        return ois;
    }
}

