/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.javabeans;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.databinding.javabeans.Java2XMLMapperException;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaBean2XMLTransformer<T>
extends BaseTransformer<Object, T>
implements PullTransformer<Object, T> {
    public static final String GET = "get";
    public static final String PREFIX = "n";
    public static final String PERIOD = ".";
    public static final String FWD_SLASH = "/";
    public static final String HTTP = "http://";
    private static int prefixCount = 1;
    protected SimpleTypeMapperImpl mapper = new SimpleTypeMapperImpl();

    @Override
    public T transform(Object source, TransformationContext context) {
        Object logical;
        DataType type;
        QName rootElement = null;
        if (context != null && (type = context.getTargetDataType()) != null && (logical = type.getLogical()) instanceof XMLType) {
            rootElement = ((XMLType)logical).getElementName();
        }
        QName rootElementName = new QName(this.resolveRootElementName(source.getClass()));
        T root = this.createElement(rootElementName);
        this.appendChildElements(root, this.resolveElementName(source.getClass()), source.getClass(), source, context);
        return root;
    }

    private void appendChildElements(T parent, QName elementName, Class javaType, Object javaObject, TransformationContext context) {
        block16: {
            T element = null;
            if (javaObject == null) break block16;
            if (javaType.isPrimitive() || this.isSimpleJavaType(javaObject)) {
                this.appendText(parent, this.mapper.toXMLLiteral(null, javaObject, context));
            } else if (javaType.isArray()) {
                int size = Array.getLength(javaObject);
                for (int count = 0; count < size; ++count) {
                    Object item = Array.get(javaObject, count);
                    element = this.createElement(elementName);
                    this.appendChild(parent, element);
                    this.appendChildElements(element, elementName, javaType.getComponentType(), item, context);
                }
            } else {
                Field[] javaFields;
                for (Field aField : javaFields = javaType.getFields()) {
                    try {
                        QName fieldElementName = new QName(aField.getName());
                        if (!aField.getType().isArray()) {
                            element = this.createElement(fieldElementName);
                            this.appendChild(parent, element);
                            this.appendChildElements(element, fieldElementName, aField.getType(), aField.get(javaObject), context);
                            continue;
                        }
                        this.appendChildElements(parent, fieldElementName, aField.getType(), aField.get(javaObject), context);
                    }
                    catch (IllegalAccessException e) {
                        Java2XMLMapperException java2xmlEx = new Java2XMLMapperException(e);
                        java2xmlEx.setJavaFieldName(aField.getName());
                        java2xmlEx.setJavaType(javaType);
                        throw java2xmlEx;
                    }
                }
                Method[] methods = javaType.getMethods();
                String fieldName = null;
                for (Method aMethod : methods) {
                    Java2XMLMapperException java2xmlEx;
                    try {
                        if (!Modifier.isPublic(aMethod.getModifiers()) || !aMethod.getName().startsWith(GET) || aMethod.getParameterTypes().length != 0 || !this.isMappedGetter(aMethod.getName())) continue;
                        fieldName = this.resolveFieldFromMethod(aMethod.getName());
                        try {
                            javaType.getField(fieldName);
                        }
                        catch (NoSuchFieldException e) {
                            QName fieldElementName = new QName(fieldName);
                            if (aMethod.getReturnType().isArray()) {
                                this.appendChildElements(parent, fieldElementName, aMethod.getReturnType(), aMethod.invoke(javaObject, new Object[0]), context);
                                continue;
                            }
                            element = this.createElement(fieldElementName);
                            this.appendChild(parent, element);
                            this.appendChildElements(element, fieldElementName, aMethod.getReturnType(), aMethod.invoke(javaObject, new Object[0]), context);
                        }
                    }
                    catch (IllegalAccessException e) {
                        java2xmlEx = new Java2XMLMapperException(e);
                        java2xmlEx.setJavaFieldName(fieldName);
                        java2xmlEx.setJavaType(javaType);
                        throw java2xmlEx;
                    }
                    catch (InvocationTargetException e) {
                        java2xmlEx = new Java2XMLMapperException(e);
                        java2xmlEx.setJavaFieldName(fieldName);
                        java2xmlEx.setJavaType(javaType);
                        throw java2xmlEx;
                    }
                }
            }
        }
    }

    protected boolean isMappedGetter(String methodName) {
        return true;
    }

    @Override
    public String getSourceDataBinding() {
        return "java:complexType";
    }

    @Override
    public Class<Object> getSourceType() {
        return Object.class;
    }

    private boolean isSimpleJavaType(Object javaObject) {
        if (javaObject instanceof String) {
            return true;
        }
        if (javaObject instanceof Byte || javaObject instanceof Character || javaObject instanceof Short || javaObject instanceof Integer || javaObject instanceof Long || javaObject instanceof Float || javaObject instanceof Double || javaObject instanceof Boolean) {
            return true;
        }
        return javaObject instanceof GregorianCalendar || javaObject instanceof Date || javaObject instanceof XMLGregorianCalendar || javaObject instanceof byte[] || javaObject instanceof QName;
    }

    private String resolveRootElementName(Class javaType) {
        if (javaType.isArray()) {
            return javaType.getComponentType().getSimpleName() + "_collection";
        }
        return javaType.getSimpleName() + "_instance";
    }

    private QName resolveElementName(Class javaType) {
        if (javaType.isArray()) {
            return new QName(javaType.getComponentType().getSimpleName());
        }
        return new QName(javaType.getSimpleName());
    }

    private String resolveFieldFromMethod(String methodName) {
        StringBuffer fieldName = new StringBuffer();
        fieldName.append(Character.toLowerCase(methodName.charAt(GET.length())));
        fieldName.append(methodName.substring(GET.length() + 1));
        return fieldName.toString();
    }

    public String getNexPrefix() {
        return PREFIX + prefixCount++;
    }

    @Override
    public int getWeight() {
        return 10000;
    }

    public abstract T createElement(QName var1) throws Java2XMLMapperException;

    public abstract void appendText(T var1, String var2) throws Java2XMLMapperException;

    public abstract void appendChild(T var1, T var2) throws Java2XMLMapperException;
}

