/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.axiom;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.ObjectOutputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.axiom.AxiomHelper;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.impl.XSDDataTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Externalizable2OMElement
extends BaseTransformer<Externalizable, OMElement>
implements PullTransformer<Externalizable, OMElement> {
    @Override
    protected Class<Externalizable> getSourceType() {
        return Externalizable.class;
    }

    @Override
    protected Class<OMElement> getTargetType() {
        return OMElement.class;
    }

    @Override
    public OMElement transform(Externalizable source, TransformationContext context) {
        OMElement element = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(source);
            out.close();
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMNamespace ns = AxiomHelper.createOMNamespace(factory, new QName("http://callable"));
            element = factory.createOMElement("reference", ns);
            element.setText(XSDDataTypeConverter.Base64Binary.encode(bos.toByteArray()));
            return element;
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    public int getWeight() {
        return 10;
    }
}

