/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.store;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.tuscany.sca.core.event.BaseEventPublisher;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.store.DuplicateRecordException;
import org.apache.tuscany.sca.store.RecoveryListener;
import org.apache.tuscany.sca.store.Store;
import org.apache.tuscany.sca.store.StoreExpirationEvent;
import org.apache.tuscany.sca.store.StoreMonitor;
import org.apache.tuscany.sca.store.StoreWriteException;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Service;

@Service(value=Store.class)
@EagerInit
public class MemoryStore
extends BaseEventPublisher
implements Store {
    private Map<RuntimeComponent, Map<String, Record>> store;
    private ScheduledExecutorService scheduler;
    private long reaperInterval = 300000L;
    private StoreMonitor monitor;
    private long defaultExpirationOffset = 600000L;

    public MemoryStore(StoreMonitor monitor) {
        this.monitor = monitor;
        this.store = new ConcurrentHashMap<RuntimeComponent, Map<String, Record>>();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    public long getDefaultExpirationOffset() {
        return this.defaultExpirationOffset;
    }

    @Property
    public void setDefaultExpirationOffset(long defaultExpirationOffset) {
        this.defaultExpirationOffset = defaultExpirationOffset;
    }

    @Property
    public void setReaperInterval(long reaperInterval) {
        this.reaperInterval = reaperInterval;
    }

    public long getReaperInterval() {
        return this.reaperInterval;
    }

    @Init
    public void init() {
        this.scheduler.scheduleWithFixedDelay(new Reaper(), this.reaperInterval, this.reaperInterval, TimeUnit.MILLISECONDS);
        this.monitor.start("In-memory store started");
    }

    @Destroy
    public void destroy() {
        this.scheduler.shutdown();
        this.monitor.stop("In-memory store stopped");
    }

    public void insertRecord(RuntimeComponent owner, String id, Object object, long expiration) throws StoreWriteException {
        Map<String, Record> map = this.store.get(owner);
        if (map == null) {
            map = new ConcurrentHashMap<String, Record>();
            this.store.put(owner, map);
        }
        if (map.containsKey(id)) {
            throw new DuplicateRecordException("Duplicate record: " + owner.getURI() + " : " + id);
        }
        map.put(id, new Record(object, expiration));
    }

    public void updateRecord(RuntimeComponent owner, String id, Object object, long expiration) throws StoreWriteException {
        Map<String, Record> map = this.store.get(owner);
        if (map == null) {
            throw new StoreWriteException("Record not found: " + owner.getURI() + " : " + id);
        }
        Record record = map.get(id);
        if (record == null) {
            throw new StoreWriteException("Record not found: " + owner.getURI() + " : " + id);
        }
        record.data = object;
    }

    public Object readRecord(RuntimeComponent owner, String id) {
        Map<String, Record> map = this.store.get(owner);
        if (map == null) {
            return null;
        }
        Record record = map.get(id);
        if (record != null) {
            return record.data;
        }
        return null;
    }

    public void removeRecords() {
        this.store.clear();
    }

    public void removeRecord(RuntimeComponent owner, String id) throws StoreWriteException {
        Map<String, Record> map = this.store.get(owner);
        if (map == null) {
            throw new StoreWriteException("Owner not found: " + owner.getURI() + " : " + id);
        }
        if (map.remove(id) == null) {
            throw new StoreWriteException("Owner not found: " + owner.getURI() + " : " + id);
        }
    }

    public void recover(RecoveryListener listener) {
        throw new UnsupportedOperationException();
    }

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        public void run() {
            long now = System.currentTimeMillis();
            for (Map.Entry entries : MemoryStore.this.store.entrySet()) {
                for (Map.Entry entry : ((Map)entries.getValue()).entrySet()) {
                    long expiration = ((Record)entry.getValue()).expiration;
                    if (expiration == -2L || now < expiration) continue;
                    RuntimeComponent owner = (RuntimeComponent)entries.getKey();
                    Object instance = ((Record)entry.getValue()).getData();
                    StoreExpirationEvent event = new StoreExpirationEvent(this, owner, instance);
                    MemoryStore.this.publish(event);
                    ((Map)entries.getValue()).remove(entry.getKey());
                }
            }
        }
    }

    private class Record {
        private Object data;
        private long expiration = -2L;

        public Record(Object data, long expiration) {
            this.data = data;
            this.expiration = expiration;
        }

        public Object getData() {
            return this.data;
        }

        public long getExpiration() {
            return this.expiration;
        }
    }
}

