/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.scope;

import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.scope.AbstractScopeContainer;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.TargetDestructionException;
import org.apache.tuscany.sca.core.scope.TargetNotFoundException;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeScopeContainer<KEY>
extends AbstractScopeContainer<KEY> {
    private InstanceWrapper<?> wrapper;

    public CompositeScopeContainer(RuntimeComponent component) {
        super(Scope.COMPOSITE, component);
    }

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.wrapper != null) {
            try {
                this.wrapper.stop();
            }
            catch (TargetDestructionException e) {
                throw new IllegalStateException(e);
            }
        }
        this.wrapper = null;
    }

    @Override
    public synchronized InstanceWrapper getWrapper(KEY contextId) throws TargetResolutionException {
        if (this.wrapper == null) {
            this.wrapper = this.createInstanceWrapper();
            this.wrapper.start();
        }
        return this.wrapper;
    }

    @Override
    public InstanceWrapper getAssociatedWrapper(KEY contextId) throws TargetResolutionException {
        if (this.wrapper == null) {
            throw new TargetNotFoundException(this.component.getURI());
        }
        return this.wrapper;
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.isEagerInit()) {
            try {
                this.getWrapper(null);
            }
            catch (TargetResolutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

