/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.util.List;
import org.apache.tuscany.sca.core.invocation.CallbackReferenceImpl;
import org.apache.tuscany.sca.core.invocation.ProxyCreationException;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.CallableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleProxyFactory
implements ProxyFactory {
    private ProxyFactoryExtensionPoint proxyFactories;

    public ExtensibleProxyFactory(ProxyFactoryExtensionPoint proxyFactories) {
        this.proxyFactories = proxyFactories;
    }

    @Override
    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (interfaceFactory.isProxyClass(target.getClass())) {
            return interfaceFactory.cast(target);
        }
        if (classFactory != null && classFactory.isProxyClass(target.getClass())) {
            return classFactory.cast(target);
        }
        throw new IllegalArgumentException("The target is not a callable proxy");
    }

    @Override
    public <T> T createCallbackProxy(Class<T> interfaze, List<RuntimeWire> wires) throws ProxyCreationException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (interfaze.isInterface()) {
            return interfaceFactory.createCallbackProxy(interfaze, wires);
        }
        return classFactory.createCallbackProxy(interfaze, wires);
    }

    @Override
    public <T> T createProxy(CallableReference<T> callableReference) throws ProxyCreationException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (callableReference.getBusinessInterface().isInterface()) {
            return interfaceFactory.createProxy(callableReference);
        }
        return classFactory.createProxy(callableReference);
    }

    @Override
    public <T> T createCallbackProxy(CallbackReferenceImpl<T> callbackReference) throws ProxyCreationException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (callbackReference.getBusinessInterface().isInterface()) {
            return interfaceFactory.createCallbackProxy(callbackReference);
        }
        return classFactory.createCallbackProxy(callbackReference);
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, RuntimeWire wire) throws ProxyCreationException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (interfaze.isInterface()) {
            return interfaceFactory.createProxy(interfaze, wire);
        }
        return classFactory.createProxy(interfaze, wire);
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        return interfaceFactory.isProxyClass(clazz) || classFactory != null && classFactory.isProxyClass(clazz);
    }
}

