/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.event;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tuscany.sca.event.Event;
import org.apache.tuscany.sca.event.EventFilter;
import org.apache.tuscany.sca.event.EventPublisher;
import org.apache.tuscany.sca.event.RuntimeEventListener;
import org.apache.tuscany.sca.event.TrueFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEventPublisher
implements EventPublisher {
    protected static final EventFilter TRUE_FILTER = new TrueFilter();
    protected Map<EventFilter, List<RuntimeEventListener>> listeners;

    @Override
    public void addListener(RuntimeEventListener listener) {
        this.addListener(TRUE_FILTER, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(RuntimeEventListener listener) {
        assert (listener != null) : "Listener cannot be null";
        Map<EventFilter, List<RuntimeEventListener>> map = this.getListeners();
        synchronized (map) {
            for (List<RuntimeEventListener> currentList : this.getListeners().values()) {
                for (RuntimeEventListener current : currentList) {
                    if (current != listener) continue;
                    currentList.remove(current);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(EventFilter filter, RuntimeEventListener listener) {
        assert (listener != null) : "Listener cannot be null";
        Map<EventFilter, List<RuntimeEventListener>> map = this.getListeners();
        synchronized (map) {
            List<RuntimeEventListener> list = this.getListeners().get(filter);
            if (list == null) {
                list = new CopyOnWriteArrayList<RuntimeEventListener>();
                this.listeners.put(filter, list);
            }
            list.add(listener);
        }
    }

    @Override
    public void publish(Event event) {
        assert (event != null) : "Event object was null";
        for (Map.Entry<EventFilter, List<RuntimeEventListener>> entry : this.getListeners().entrySet()) {
            if (!entry.getKey().match(event)) continue;
            for (RuntimeEventListener listener : entry.getValue()) {
                listener.onEvent(event);
            }
        }
    }

    protected Map<EventFilter, List<RuntimeEventListener>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ConcurrentHashMap<EventFilter, List<RuntimeEventListener>>();
        }
        return this.listeners;
    }
}

