/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.xml.StAXHelper;
import org.osoa.sca.CallableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallableReference2XMLStreamReader
extends BaseTransformer<CallableReference, XMLStreamReader>
implements PullTransformer<CallableReference, XMLStreamReader> {
    @Override
    protected Class<CallableReference> getSourceType() {
        return CallableReference.class;
    }

    @Override
    protected Class<XMLStreamReader> getTargetType() {
        return XMLStreamReader.class;
    }

    @Override
    public XMLStreamReader transform(CallableReference source, TransformationContext context) {
        try {
            if (source != null) {
                if (source instanceof CallableReferenceImpl) {
                    XMLStreamReader xmlReader = ((CallableReferenceImpl)source).getXMLReader();
                    if (xmlReader != null) {
                        return xmlReader;
                    }
                    String xmlString = ((CallableReferenceImpl)source).toXMLString();
                    return StAXHelper.createXMLStreamReader("<reference xmlns=\"http://callable\">" + xmlString.substring(xmlString.indexOf("?>") + 2) + "</reference>");
                }
                throw new TransformationException("Unrecognized transformation source object");
            }
            return null;
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    public int getWeight() {
        return 10;
    }
}

