/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.lang.reflect.Array;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array2ArrayTransformer
extends BaseTransformer<Object, Object>
implements PullTransformer<Object, Object> {
    protected Mediator mediator;

    @Reference
    public void setMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    @Override
    public String getSourceDataBinding() {
        return "java:array";
    }

    @Override
    public String getTargetDataBinding() {
        return "java:array";
    }

    @Override
    protected Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    protected Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public Object transform(Object array, TransformationContext context) {
        try {
            if (array == null) {
                return null;
            }
            DataType sourceType = context.getSourceDataType();
            DataType targetType = context.getTargetDataType();
            int length = Array.getLength(array);
            Object targetArray = Array.newInstance(targetType.getPhysical().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Object sourceItem = Array.get(array, i);
                Object targetItem = this.mediator.mediate(sourceItem, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
                Array.set(targetArray, i, targetItem);
            }
            return targetArray;
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }
}

