/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.core.context.ComponentContextHelper;
import org.apache.tuscany.sca.core.context.RequestContextImpl;
import org.apache.tuscany.sca.core.context.ServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentContext;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.osoa.sca.CallableReference;
import org.osoa.sca.RequestContext;
import org.osoa.sca.ServiceReference;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContextImpl
implements RuntimeComponentContext {
    private final RuntimeComponent component;
    private final CompositeActivator compositeActivator;
    private final RequestContextFactory requestContextFactory;
    private final ProxyFactory proxyFactory;
    private final AssemblyFactory assemblyFactory;
    private final JavaInterfaceFactory javaInterfaceFactory;
    private PropertyValueFactory propertyFactory;

    public ComponentContextImpl(CompositeActivator compositeActivator, AssemblyFactory assemblyFactory, ProxyFactory proxyFactory, InterfaceContractMapper interfaceContractMapper, RequestContextFactory requestContextFactory, JavaInterfaceFactory javaInterfaceFactory, RuntimeComponent component) {
        this.compositeActivator = compositeActivator;
        this.assemblyFactory = assemblyFactory;
        this.proxyFactory = proxyFactory;
        this.requestContextFactory = requestContextFactory;
        this.javaInterfaceFactory = javaInterfaceFactory;
        this.component = component;
    }

    @Override
    public String getURI() {
        return this.component.getURI();
    }

    @Override
    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        return this.proxyFactory.cast(target);
    }

    @Override
    public <B> B getService(Class<B> businessInterface, String referenceName) {
        ServiceReference<B> serviceRef = this.getServiceReference(businessInterface, referenceName);
        return serviceRef.getService();
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String referenceName) {
        try {
            for (ComponentReference ref : this.component.getReferences()) {
                if (!referenceName.equals(ref.getName())) continue;
                Multiplicity multiplicity = ref.getMultiplicity();
                if (multiplicity == Multiplicity.ZERO_N || multiplicity == Multiplicity.ONE_N) {
                    throw new IllegalArgumentException("Reference " + referenceName + " has multiplicity " + (Object)((Object)multiplicity));
                }
                return this.getServiceReference(businessInterface, (RuntimeComponentReference)ref, null);
            }
            throw new ServiceRuntimeException("Reference not found: " + referenceName);
        }
        catch (ServiceRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage(), e);
        }
    }

    public void setPropertyValueFactory(PropertyValueFactory factory) {
        this.propertyFactory = factory;
    }

    @Override
    public <B> B getProperty(Class<B> type, String propertyName) {
        for (ComponentProperty p : this.component.getProperties()) {
            if (!propertyName.equals(p.getName())) continue;
            return this.propertyFactory.createPropertyValue(p, type);
        }
        throw new ServiceRuntimeException("Property not found: " + propertyName);
    }

    @Override
    public <B> ServiceReference<B> createSelfReference(Class<B> businessInterface) {
        ComponentService service = ComponentContextHelper.getSingleService(this.component);
        try {
            return this.createSelfReference(businessInterface, service);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public <B> ServiceReference<B> createSelfReference(Class<B> businessInterface, String serviceName) {
        try {
            for (ComponentService service : this.component.getServices()) {
                if (!serviceName.equals(service.getName())) continue;
                return this.createSelfReference(businessInterface, service);
            }
            throw new ServiceRuntimeException("Service not found: " + serviceName);
        }
        catch (ServiceRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public <B> ServiceReference<B> createSelfReference(Class<B> businessInterface, ComponentService service) {
        try {
            RuntimeComponentReference ref = (RuntimeComponentReference)this.createSelfReference(this.component, service, businessInterface);
            ref.setComponent(this.component);
            return this.getServiceReference(businessInterface, ref, null);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public RequestContext getRequestContext() {
        if (this.requestContextFactory != null) {
            return this.requestContextFactory.createRequestContext();
        }
        return new RequestContextImpl(this.proxyFactory);
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, RuntimeComponentReference reference, Binding binding) {
        try {
            InterfaceContract refInterfaceContract;
            RuntimeComponentReference ref = reference;
            InterfaceContract interfaceContract = reference.getInterfaceContract();
            Reference componentTypeReference = reference.getReference();
            if (componentTypeReference != null && componentTypeReference.getInterfaceContract() != null) {
                interfaceContract = componentTypeReference.getInterfaceContract();
            }
            if ((refInterfaceContract = this.getInterfaceContract(interfaceContract, businessInterface)) != interfaceContract) {
                ref = (RuntimeComponentReference)reference.clone();
                if (interfaceContract != null) {
                    ref.setInterfaceContract(interfaceContract);
                } else {
                    ref.setInterfaceContract(refInterfaceContract);
                }
            }
            ref.setComponent(this.component);
            return new ServiceReferenceImpl<B>(businessInterface, this.component, ref, binding, this.proxyFactory, this.compositeActivator);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, RuntimeComponentReference reference, RuntimeComponent component, RuntimeComponentService service) {
        try {
            InterfaceContract refInterfaceContract;
            RuntimeComponentReference ref = (RuntimeComponentReference)reference.clone();
            InterfaceContract interfaceContract = reference.getInterfaceContract();
            Reference componentTypeReference = reference.getReference();
            if (componentTypeReference != null && componentTypeReference.getInterfaceContract() != null) {
                interfaceContract = componentTypeReference.getInterfaceContract();
            }
            if ((refInterfaceContract = this.getInterfaceContract(interfaceContract, businessInterface)) != interfaceContract) {
                ref = (RuntimeComponentReference)reference.clone();
                ref.setInterfaceContract(interfaceContract);
            }
            ref.getTargets().add(service);
            ref.getBindings().clear();
            for (Binding binding : service.getBindings()) {
                if (binding instanceof OptimizableBinding) {
                    OptimizableBinding optimizableBinding = (OptimizableBinding)((OptimizableBinding)binding).clone();
                    optimizableBinding.setTargetBinding(binding);
                    optimizableBinding.setTargetComponent(component);
                    optimizableBinding.setTargetComponentService(service);
                    ref.getBindings().add(optimizableBinding);
                    continue;
                }
                ref.getBindings().add(binding);
            }
            return new ServiceReferenceImpl<B>(businessInterface, component, ref, this.proxyFactory, this.compositeActivator);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public <B> CallableReference<B> getCallableReference(Class<B> businessInterface, RuntimeComponent component, RuntimeComponentService service) {
        try {
            if (businessInterface == null) {
                InterfaceContract contract = service.getInterfaceContract();
                businessInterface = ((JavaInterface)contract.getInterface()).getJavaClass();
            }
            RuntimeComponentReference ref = (RuntimeComponentReference)this.createSelfReference(component, service, businessInterface);
            ref.setComponent(component);
            return new CallableReferenceImpl<B>(businessInterface, component, ref, null, this.proxyFactory, this.compositeActivator);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    private ComponentReference createSelfReference(Component component, ComponentService service, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        ComponentReference componentReference = this.assemblyFactory.createComponentReference();
        componentReference.setName("$self$." + service.getName());
        for (Binding binding : service.getBindings()) {
            if (binding instanceof OptimizableBinding) {
                OptimizableBinding optimizableBinding = (OptimizableBinding)((OptimizableBinding)binding).clone();
                optimizableBinding.setTargetBinding(binding);
                optimizableBinding.setTargetComponent(component);
                optimizableBinding.setTargetComponentService(service);
                componentReference.getBindings().add(optimizableBinding);
                continue;
            }
            componentReference.getBindings().add(binding);
        }
        componentReference.setCallback(service.getCallback());
        componentReference.getTargets().add(service);
        componentReference.getPolicySets().addAll(service.getPolicySets());
        componentReference.getRequiredIntents().addAll(service.getRequiredIntents());
        InterfaceContract interfaceContract = service.getInterfaceContract();
        Service componentTypeService = service.getService();
        if (componentTypeService != null && componentTypeService.getInterfaceContract() != null) {
            interfaceContract = componentTypeService.getInterfaceContract();
        }
        interfaceContract = this.getInterfaceContract(interfaceContract, businessInterface);
        componentReference.setInterfaceContract(interfaceContract);
        componentReference.setMultiplicity(Multiplicity.ONE_ONE);
        return componentReference;
    }

    private InterfaceContract getInterfaceContract(InterfaceContract interfaceContract, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Class<?> cls;
        Interface interfaze;
        boolean compatible = false;
        if (interfaceContract != null && interfaceContract.getInterface() != null && (interfaze = interfaceContract.getInterface()) instanceof JavaInterface && businessInterface.isAssignableFrom(cls = ((JavaInterface)interfaze).getJavaClass())) {
            compatible = true;
        }
        if (!compatible) {
            interfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
            JavaInterface callInterface = this.javaInterfaceFactory.createJavaInterface(businessInterface);
            interfaceContract.setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                interfaceContract.setCallbackInterface(this.javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass()));
            }
        }
        return interfaceContract;
    }

    public CompositeActivator getCompositeActivator() {
        return this.compositeActivator;
    }

    @Override
    public void start(RuntimeComponentReference reference) {
        this.compositeActivator.start(this.component, reference);
    }

    @Override
    public RuntimeComponent read(Reader reader) throws IOException {
        RuntimeComponent component = this.compositeActivator.getComponentContextHelper().read(reader);
        this.compositeActivator.configureComponentContext(component);
        return component;
    }

    @Override
    public void write(RuntimeComponentReference reference, Writer writer) throws IOException {
        this.compositeActivator.getComponentContextHelper().write(this.component, reference, writer);
    }

    @Override
    public <B> Collection<B> getServices(Class<B> businessInterface, String referenceName) {
        ArrayList services = new ArrayList();
        Collection<ServiceReference<B>> serviceRefs = this.getServiceReferences(businessInterface, referenceName);
        for (ServiceReference<B> serviceRef : serviceRefs) {
            services.add(serviceRef.getService());
        }
        return services;
    }

    @Override
    public <B> Collection<ServiceReference<B>> getServiceReferences(Class<B> businessInterface, String referenceName) {
        try {
            for (ComponentReference ref : this.component.getReferences()) {
                if (!referenceName.equals(ref.getName())) continue;
                ArrayList<ServiceReference<B>> serviceRefs = new ArrayList<ServiceReference<B>>();
                for (Binding binding : ref.getBindings()) {
                    serviceRefs.add(this.getServiceReference(businessInterface, (RuntimeComponentReference)ref, binding));
                }
                return serviceRefs;
            }
            throw new ServiceRuntimeException("Reference not found: " + referenceName);
        }
        catch (ServiceRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage(), e);
        }
    }
}

