/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.impl.ComponentReferenceImpl;
import org.apache.tuscany.sca.core.assembly.EndpointWireImpl;
import org.apache.tuscany.sca.endpointresolver.EndpointResolver;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeComponentReferenceImpl
extends ComponentReferenceImpl
implements RuntimeComponentReference {
    private ArrayList<RuntimeWire> wires;
    private HashMap<Binding, ReferenceBindingProvider> bindingProviders = new HashMap();
    private HashMap<Endpoint, EndpointResolver> endpointResolvers = new HashMap();
    private HashMap<Binding, List<PolicyProvider>> policyProviders = new HashMap();
    private RuntimeComponent component;

    @Override
    public synchronized List<RuntimeWire> getRuntimeWires() {
        if (this.wires == null) {
            this.wires = new ArrayList();
            this.component.getComponentContext().start(this);
        }
        return this.wires;
    }

    @Override
    public RuntimeWire getRuntimeWire(Binding binding) {
        for (RuntimeWire wire : this.getRuntimeWires()) {
            if (wire.getSource().getBinding() != binding) continue;
            return wire;
        }
        for (RuntimeWire wire : this.getRuntimeWires()) {
            if (!(wire instanceof EndpointWireImpl)) continue;
            Endpoint endpoint = ((EndpointWireImpl)wire).getEndpoint();
            for (Binding b : endpoint.getCandidateBindings()) {
                if (b != binding) continue;
                return wire;
            }
        }
        return null;
    }

    @Override
    public ReferenceBindingProvider getBindingProvider(Binding binding) {
        return this.bindingProviders.get(binding);
    }

    @Override
    public void setBindingProvider(Binding binding, ReferenceBindingProvider bindingProvider) {
        this.bindingProviders.put(binding, bindingProvider);
    }

    @Override
    public EndpointResolver getEndpointResolver(Endpoint endpoint) {
        return this.endpointResolvers.get(endpoint);
    }

    @Override
    public void setEndpointResolver(Endpoint endpoint, EndpointResolver endpointResolver) {
        this.endpointResolvers.put(endpoint, endpointResolver);
    }

    @Override
    public Invoker getInvoker(Binding binding, Operation operation) {
        RuntimeWire wire = this.getRuntimeWire(binding);
        if (wire == null) {
            return null;
        }
        InvocationChain chain = wire.getInvocationChain(operation);
        return chain == null ? null : chain.getHeadInvoker();
    }

    public RuntimeComponent getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(RuntimeComponent component) {
        this.component = component;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RuntimeComponentReferenceImpl ref = (RuntimeComponentReferenceImpl)super.clone();
        ref.wires = null;
        ref.bindingProviders = new HashMap();
        ref.policyProviders = new HashMap();
        return ref;
    }

    @Override
    public void addPolicyProvider(Binding binding, PolicyProvider policyProvider) {
        List<PolicyProvider> providers = this.policyProviders.get(binding);
        if (providers == null) {
            providers = new ArrayList<PolicyProvider>();
            this.policyProviders.put(binding, providers);
        }
        providers.add(policyProvider);
    }

    @Override
    public List<PolicyProvider> getPolicyProviders(Binding binding) {
        return this.policyProviders.get(binding);
    }

    public String toString() {
        return this.getName();
    }
}

