/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.core.ModuleActivatorExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleActivatorExtensionPoint
implements ModuleActivatorExtensionPoint {
    private List<ModuleActivator> activators = new ArrayList<ModuleActivator>();
    private boolean loadedActivators;

    @Override
    public void addModuleActivator(ModuleActivator activator) {
        this.activators.add(activator);
    }

    @Override
    public List<ModuleActivator> getModuleActivators() {
        this.loadModuleActivators();
        return this.activators;
    }

    @Override
    public void removeModuleActivator(Object activator) {
        this.activators.remove(activator);
    }

    private void loadModuleActivators() {
        Set<ServiceDeclaration> activatorDeclarations;
        if (this.loadedActivators) {
            return;
        }
        try {
            activatorDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(ModuleActivator.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration activatorDeclaration : activatorDeclarations) {
            ModuleActivator activator;
            try {
                Class<?> activatorClass = activatorDeclaration.loadClass();
                activator = (ModuleActivator)activatorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            this.addModuleActivator(activator);
        }
        this.loadedActivators = true;
    }
}

