/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.service.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.service.TypeDescriber;
import org.apache.tuscany.sca.contribution.service.util.FileHelper;

public class PackageTypeDescriberImpl
implements TypeDescriber {
    private final Map<String, String> contentTypeRegistry = new HashMap<String, String>();

    public PackageTypeDescriberImpl() {
        this.init();
    }

    private void init() {
        this.contentTypeRegistry.put("JAR", "application/x-compressed");
        this.contentTypeRegistry.put("WAR", "application/x-compressed");
        this.contentTypeRegistry.put("ZIP", "application/x-compressed");
    }

    protected String resolveContentyTypeByExtension(URL resourceURL) {
        String artifactExtension = FileHelper.getExtension(resourceURL.getPath());
        if (artifactExtension == null) {
            return null;
        }
        return this.contentTypeRegistry.get(artifactExtension.toUpperCase());
    }

    public String getType(URL resourceURL, String defaultContentType) {
        URLConnection connection = null;
        String contentType = defaultContentType;
        String urlProtocol = resourceURL.getProtocol();
        if (urlProtocol.equals("file")) {
            String type;
            final File fileOrDir = FileHelper.toFile(resourceURL);
            Boolean isDirectory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return fileOrDir.isDirectory();
                }
            });
            if (isDirectory.booleanValue()) {
                contentType = "application/vnd.tuscany.folder";
            }
            if ((type = this.resolveContentyTypeByExtension(resourceURL)) != null) {
                return type;
            }
        } else if (urlProtocol.equals("bundle") || urlProtocol.equals("bundleresource")) {
            contentType = "application/osgi.bundle";
        } else {
            contentType = this.resolveContentyTypeByExtension(resourceURL);
            if (contentType == null) {
                try {
                    connection = resourceURL.openConnection();
                    connection.setUseCaches(false);
                    contentType = connection.getContentType();
                    if (contentType == null || contentType.equals("content/unknown")) {
                        contentType = defaultContentType;
                    }
                }
                catch (IOException io) {
                    // empty catch block
                }
            }
        }
        return contentType == null ? defaultContentType : contentType;
    }
}

