/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.PackageProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionException;
import org.apache.tuscany.sca.contribution.service.ContributionRepository;
import org.apache.tuscany.sca.contribution.service.ContributionService;
import org.apache.tuscany.sca.contribution.service.ExtensibleContributionListener;
import org.apache.tuscany.sca.contribution.service.util.IOHelper;
import org.apache.tuscany.sca.contribution.xml.ContributionMetadataDocumentProcessor;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionServiceImpl
implements ContributionService {
    private ContributionRepository contributionRepository;
    private PackageProcessor packageProcessor;
    private URLArtifactProcessor artifactProcessor;
    private StAXArtifactProcessor staxProcessor;
    private ExtensibleContributionListener contributionListener;
    private ModelResolverExtensionPoint modelResolvers;
    private ModelFactoryExtensionPoint modelFactories;
    private XMLInputFactory xmlFactory;
    private AssemblyFactory assemblyFactory;
    private ContributionFactory contributionFactory;
    private ModelResolver policyDefinitionsResolver;
    private List policyDefinitions;
    private Monitor monitor;
    private String COMPOSITE_FILE_EXTN = ".composite";

    public ContributionServiceImpl(ContributionRepository repository, PackageProcessor packageProcessor, URLArtifactProcessor documentProcessor, StAXArtifactProcessor staxProcessor, ExtensibleContributionListener contributionListener, ModelResolver policyDefinitionsResolver, ModelResolverExtensionPoint modelResolvers, ModelFactoryExtensionPoint modelFactories, AssemblyFactory assemblyFactory, ContributionFactory contributionFactory, XMLInputFactory xmlFactory, List<SCADefinitions> policyDefinitions, Monitor monitor) {
        this.contributionRepository = repository;
        this.packageProcessor = packageProcessor;
        this.artifactProcessor = documentProcessor;
        this.staxProcessor = staxProcessor;
        this.contributionListener = contributionListener;
        this.modelResolvers = modelResolvers;
        this.modelFactories = modelFactories;
        this.xmlFactory = xmlFactory;
        this.assemblyFactory = assemblyFactory;
        this.contributionFactory = contributionFactory;
        this.policyDefinitionsResolver = policyDefinitionsResolver;
        this.policyDefinitions = policyDefinitions;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-impl-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public Contribution contribute(String contributionURI, URL sourceURL, boolean storeInRepository) throws ContributionException, IOException {
        if (contributionURI == null) {
            this.error("ContributionURINull", contributionURI, new Object[0]);
            throw new IllegalArgumentException("URI for the contribution is null");
        }
        if (sourceURL == null) {
            this.error("SourceURLNull", sourceURL, new Object[0]);
            throw new IllegalArgumentException("Source URL for the contribution is null");
        }
        return this.addContribution(contributionURI, sourceURL, null, null, storeInRepository);
    }

    @Override
    public Contribution contribute(String contributionURI, URL sourceURL, ModelResolver modelResolver, boolean storeInRepository) throws ContributionException, IOException {
        if (contributionURI == null) {
            this.error("ContributionURINull", contributionURI, new Object[0]);
            throw new IllegalArgumentException("URI for the contribution is null");
        }
        if (sourceURL == null) {
            this.error("SourceURLNull", sourceURL, new Object[0]);
            throw new IllegalArgumentException("Source URL for the contribution is null");
        }
        return this.addContribution(contributionURI, sourceURL, null, modelResolver, storeInRepository);
    }

    @Override
    public Contribution contribute(String contributionURI, URL sourceURL, InputStream input) throws ContributionException, IOException {
        return this.addContribution(contributionURI, sourceURL, input, null, true);
    }

    @Override
    public Contribution contribute(String contributionURI, URL sourceURL, InputStream input, ModelResolver modelResolver) throws ContributionException, IOException {
        return this.addContribution(contributionURI, sourceURL, input, modelResolver, true);
    }

    @Override
    public Contribution getContribution(String uri) {
        return this.contributionRepository.getContribution(uri);
    }

    @Override
    public void remove(String uri) throws ContributionException {
        Contribution contribution = this.contributionRepository.getContribution(uri);
        this.contributionRepository.removeContribution(contribution);
        this.contributionListener.contributionRemoved(this.contributionRepository, contribution);
    }

    @Override
    public void addDeploymentComposite(Contribution contribution, Composite composite) throws ContributionException {
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setURI(composite.getURI());
        artifact.setModel(composite);
        contribution.getArtifacts().add(artifact);
        contribution.getDeployables().add(composite);
    }

    private Contribution readContributionMetadata(URL sourceURL) throws ContributionException {
        Contribution contributionMetadata = this.contributionFactory.createContribution();
        ContributionMetadataDocumentProcessor metadataDocumentProcessor = new ContributionMetadataDocumentProcessor(this.modelFactories, this.staxProcessor, this.monitor);
        final URL[] urls = new URL[]{sourceURL};
        URLClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, null);
            }
        });
        for (String path : new String[]{"META-INF/sca-contribution-generated.xml", "META-INF/sca-contribution.xml"}) {
            URL url = cl.getResource(path);
            if (url == null) continue;
            ContributionMetadata contribution = metadataDocumentProcessor.read(sourceURL, URI.create(path), url);
            contributionMetadata.getImports().addAll(contribution.getImports());
            contributionMetadata.getExports().addAll(contribution.getExports());
            contributionMetadata.getDeployables().addAll(contribution.getDeployables());
        }
        return contributionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Contribution addContribution(String contributionURI, URL sourceURL, InputStream contributionStream, ModelResolver modelResolver, boolean storeInRepository) throws IOException, ContributionException {
        if (contributionStream == null && sourceURL == null) {
            this.error("ContributionContentNull", contributionStream, new Object[0]);
            throw new IllegalArgumentException("The content of the contribution is null.");
        }
        URL locationURL = sourceURL;
        if (this.contributionRepository != null && storeInRepository) {
            locationURL = contributionStream == null ? this.contributionRepository.store(contributionURI, sourceURL) : this.contributionRepository.store(contributionURI, sourceURL, contributionStream);
        }
        Contribution contribution = this.readContributionMetadata(locationURL);
        if (modelResolver == null) {
            modelResolver = new ExtensibleModelResolver(contribution, this.modelResolvers, this.modelFactories, this.policyDefinitionsResolver);
        }
        contribution.setURI(contributionURI);
        contribution.setLocation(locationURL.toString());
        contribution.setModelResolver(modelResolver);
        List<URI> contributionArtifacts = null;
        if (storeInRepository || contributionStream == null) {
            URLConnection connection = sourceURL.openConnection();
            connection.setUseCaches(false);
            final URLConnection finalConnection = connection;
            try {
                contributionStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return finalConnection.getInputStream();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            try {
                contributionArtifacts = this.packageProcessor.getArtifacts(locationURL, contributionStream);
            }
            finally {
                IOHelper.closeQuietly(contributionStream);
                contributionStream = null;
            }
        }
        contributionArtifacts = this.packageProcessor.getArtifacts(locationURL, contributionStream);
        try {
            this.processReadPhase(contribution, contributionArtifacts);
        }
        catch (Exception e) {
            throw new ContributionException(e);
        }
        this.contributionListener.contributionAdded(this.contributionRepository, contribution);
        this.processResolvePhase(contribution);
        String prefix = "META-INF/sca-deployables/";
        for (Artifact artifact : contribution.getArtifacts()) {
            if (!(artifact.getModel() instanceof Composite) || !artifact.getURI().startsWith(prefix)) continue;
            Composite composite = (Composite)artifact.getModel();
            if (contribution.getDeployables().contains(composite)) continue;
            contribution.getDeployables().add(composite);
        }
        this.processApplicationComposite(contribution);
        this.contributionRepository.addContribution(contribution);
        return contribution;
    }

    private void processApplicationComposite(Contribution contribution) {
        Composite composite = this.findComposite("web-inf/web.composite", contribution);
        if (composite != null && !contribution.getDeployables().contains(composite)) {
            contribution.getDeployables().add(this.createDeploymentComposite(composite));
        }
    }

    private Composite createDeploymentComposite(Composite composite) {
        return composite;
    }

    private Composite findComposite(String name, Contribution contribution) {
        for (Artifact artifact : contribution.getArtifacts()) {
            if (!(artifact.getModel() instanceof Composite) || !name.equalsIgnoreCase(artifact.getURI())) continue;
            return (Composite)artifact.getModel();
        }
        return null;
    }

    private void processReadPhase(Contribution contribution, List<URI> artifacts) throws ContributionException, MalformedURLException, XMLStreamException {
        Artifact artifact;
        URL artifactURL;
        ModelResolver modelResolver = contribution.getModelResolver();
        URL contributionURL = new URL(contribution.getLocation());
        ArrayList<URI> compositeUris = new ArrayList<URI>();
        Object model = null;
        for (URI anArtifactUri : artifacts) {
            if (anArtifactUri.toString().endsWith(this.COMPOSITE_FILE_EXTN)) {
                compositeUris.add(anArtifactUri);
                continue;
            }
            artifactURL = this.packageProcessor.getArtifactURL(new URL(contribution.getLocation()), anArtifactUri);
            artifact = this.contributionFactory.createArtifact();
            artifact.setURI(anArtifactUri.toString());
            artifact.setLocation(artifactURL.toString());
            contribution.getArtifacts().add(artifact);
            modelResolver.addModel(artifact);
            model = this.artifactProcessor.read(contributionURL, anArtifactUri, artifactURL);
            if (model == null) continue;
            artifact.setModel(model);
            modelResolver.addModel(model);
            if (!(model instanceof SCADefinitions)) continue;
            this.policyDefinitions.add(model);
            SCADefinitions definitions = (SCADefinitions)model;
            for (Intent intent : definitions.getPolicyIntents()) {
                this.policyDefinitionsResolver.addModel(intent);
            }
            for (PolicySet policySet : definitions.getPolicySets()) {
                this.policyDefinitionsResolver.addModel(policySet);
            }
            for (IntentAttachPointType attachPointType : definitions.getBindingTypes()) {
                this.policyDefinitionsResolver.addModel(attachPointType);
            }
            for (IntentAttachPointType attachPointType : definitions.getImplementationTypes()) {
                this.policyDefinitionsResolver.addModel(attachPointType);
            }
            for (Object binding : definitions.getBindings()) {
                this.policyDefinitionsResolver.addModel(binding);
            }
        }
        for (URI anArtifactUri : compositeUris) {
            artifactURL = this.packageProcessor.getArtifactURL(new URL(contribution.getLocation()), anArtifactUri);
            artifact = this.contributionFactory.createArtifact();
            artifact.setURI(anArtifactUri.toString());
            artifact.setLocation(artifactURL.toString());
            contribution.getArtifacts().add(artifact);
            modelResolver.addModel(artifact);
            model = this.artifactProcessor.read(contributionURL, anArtifactUri, artifactURL);
            if (model == null) continue;
            artifact.setModel(model);
            modelResolver.addModel(model);
        }
    }

    private void processResolvePhase(Contribution contribution) throws ContributionException {
        ArrayList<Artifact> composites = new ArrayList<Artifact>();
        for (Artifact artifact : contribution.getArtifacts()) {
            if (artifact.getURI().endsWith(".composite")) {
                composites.add(artifact);
                continue;
            }
            if (artifact.getModel() == null) continue;
            this.artifactProcessor.resolve(artifact.getModel(), contribution.getModelResolver());
        }
        for (Artifact artifact : composites) {
            if (artifact.getModel() == null) continue;
            this.artifactProcessor.resolve(artifact.getModel(), contribution.getModelResolver());
        }
        ArrayList<Composite> resolvedDeployables = new ArrayList<Composite>();
        for (Composite deployableComposite : contribution.getDeployables()) {
            Composite resolvedDeployable = contribution.getModelResolver().resolveModel(Composite.class, deployableComposite);
            resolvedDeployables.add(resolvedDeployable);
        }
        contribution.getDeployables().clear();
        contribution.getDeployables().addAll(resolvedDeployables);
    }
}

