/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.service;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionListener;
import org.apache.tuscany.sca.contribution.service.ContributionListenerExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContributionListenerExtensionPoint
implements ContributionListenerExtensionPoint {
    private List<ContributionListener> listeners = new CopyOnWriteArrayList<ContributionListener>();
    private boolean loadedListeners;
    private ModelFactoryExtensionPoint modelFactories;

    public DefaultContributionListenerExtensionPoint(ModelFactoryExtensionPoint modelFactories) {
        this.modelFactories = modelFactories;
    }

    public DefaultContributionListenerExtensionPoint(ExtensionPointRegistry extensionPoints) {
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
    }

    @Override
    public void addContributionListener(ContributionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<ContributionListener> getContributionListeners() {
        this.loadListeners();
        return this.listeners;
    }

    @Override
    public void removeContributionListener(ContributionListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void loadListeners() {
        Set<ServiceDeclaration> listenerDeclarations;
        if (this.loadedListeners) {
            return;
        }
        try {
            listenerDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(ContributionListener.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration listenerDeclaration : listenerDeclarations) {
            ContributionListener listener;
            try {
                Class<?> listenerClass = listenerDeclaration.loadClass();
                try {
                    Constructor<?> constructor = listenerClass.getConstructor(ModelFactoryExtensionPoint.class);
                    try {
                        listener = (ContributionListener)constructor.newInstance(this.modelFactories);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                catch (NoSuchMethodException e) {
                    listener = (ContributionListener)listenerClass.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            this.addContributionListener(listener);
        }
        this.loadedListeners = true;
    }
}

