/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resource.impl;

import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.resolver.DefaultImportAllModelResolver;
import org.apache.tuscany.sca.contribution.resource.ResourceExport;
import org.apache.tuscany.sca.contribution.resource.ResourceImport;
import org.apache.tuscany.sca.contribution.service.ContributionListener;
import org.apache.tuscany.sca.contribution.service.ContributionRepository;

public class ResourceImportExportListener
implements ContributionListener {
    public void contributionAdded(ContributionRepository repository, Contribution contribution) {
        for (Export export : contribution.getExports()) {
            export.setModelResolver(contribution.getModelResolver());
        }
        for (Import import_ : contribution.getImports()) {
            Contribution targetContribution;
            boolean initialized = false;
            if (!(import_ instanceof ResourceImport)) continue;
            ResourceImport resourceImport = (ResourceImport)import_;
            if (resourceImport.getLocation() != null && (targetContribution = repository.getContribution(resourceImport.getLocation())) != null) {
                for (Export export : targetContribution.getExports()) {
                    if (!(export instanceof ResourceExport)) continue;
                    ResourceExport resourceExport = (ResourceExport)export;
                    if (!resourceImport.getURI().equals(resourceExport.getURI())) continue;
                    resourceImport.setModelResolver(resourceExport.getModelResolver());
                    initialized = true;
                    break;
                }
            }
            if (initialized) continue;
            import_.setModelResolver(new DefaultImportAllModelResolver(import_, repository.getContributions()));
        }
    }

    public void contributionRemoved(ContributionRepository repository, Contribution contribution) {
    }

    public void contributionUpdated(ContributionRepository repository, Contribution oldContribution, Contribution contribution) {
    }
}

