/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyAttributeProcessor
extends BaseStAXArtifactProcessor
implements StAXAttributeProcessor<String> {
    private static final QName ANY_ATTRIBUTE = new QName("http://www.w3.org/2001/XMLSchema", "anyAttribute");

    public AnyAttributeProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    @Override
    public QName getArtifactType() {
        return ANY_ATTRIBUTE;
    }

    @Override
    public Class<String> getModelType() {
        return String.class;
    }

    @Override
    public String read(QName attributeName, XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        return reader.getAttributeValue(attributeName.getNamespaceURI(), attributeName.getLocalPart());
    }

    @Override
    public void write(String value, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.setPrefix(ANY_ATTRIBUTE.getPrefix(), ANY_ATTRIBUTE.getNamespaceURI());
        writer.writeAttribute(ANY_ATTRIBUTE.getLocalPart(), value);
    }

    @Override
    public void resolve(String arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

