/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.contribution.processor.PackageProcessor;
import org.apache.tuscany.sca.contribution.service.ContributionException;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderContributionProcessor
implements PackageProcessor {
    @Override
    public String getPackageType() {
        return "application/vnd.tuscany.folder";
    }

    private static void traverse(List<URI> fileList, final File file, final File root) throws IOException {
        Boolean isFile = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isFile();
            }
        });
        if (isFile.booleanValue()) {
            fileList.add(AccessController.doPrivileged(new PrivilegedAction<URI>(){

                @Override
                public URI run() {
                    return root.toURI().relativize(file.toURI());
                }
            }));
        } else {
            Boolean isDirectory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.isDirectory();
                }
            });
            if (isDirectory.booleanValue()) {
                File[] files;
                String uri = AccessController.doPrivileged(new PrivilegedAction<URI>(){

                    @Override
                    public URI run() {
                        return root.toURI().relativize(file.toURI());
                    }
                }).toString();
                if (uri.endsWith("/")) {
                    uri = uri.substring(0, uri.length() - 1);
                }
                fileList.add(URI.create(uri));
                for (File f : files = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

                    @Override
                    public File[] run() {
                        return file.listFiles();
                    }
                })) {
                    if (f.getName().startsWith(".")) continue;
                    FolderContributionProcessor.traverse(fileList, f, root);
                }
            }
        }
    }

    @Override
    public URL getArtifactURL(URL sourceURL, URI artifact) throws MalformedURLException {
        return new URL(sourceURL, artifact.toString());
    }

    @Override
    public List<URI> getArtifacts(URL packageSourceURL, InputStream inputStream) throws ContributionException, IOException {
        if (packageSourceURL == null) {
            throw new IllegalArgumentException("Invalid null package source URL.");
        }
        ArrayList<URI> artifacts = new ArrayList<URI>();
        try {
            final File rootFolder = new File(packageSourceURL.toURI());
            Boolean isDirectory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return rootFolder.isDirectory();
                }
            });
            if (isDirectory.booleanValue()) {
                Boolean folderExists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return rootFolder.exists();
                    }
                });
                if (!folderExists.booleanValue()) {
                    throw new ContributionReadException(rootFolder.getAbsolutePath());
                }
                FolderContributionProcessor.traverse(artifacts, rootFolder, rootFolder);
            }
        }
        catch (URISyntaxException e) {
            throw new ContributionReadException(packageSourceURL.toExternalForm(), e);
        }
        return artifacts;
    }
}

