/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.tuscany.sca.contribution.processor.TuscanyNamespaceContext;

public class TuscanyXMLStreamReader
extends StreamReaderDelegate
implements XMLStreamReader {
    Stack<ArrayList<ArrayList<String>>> context = new Stack();
    List contextList;
    List<String> prefixList;
    List<String> uriList;

    public TuscanyXMLStreamReader(XMLStreamReader reader) {
        super(reader);
    }

    public void pushContext() throws XMLStreamException {
        this.contextList = new ArrayList();
        this.prefixList = new ArrayList<String>();
        this.uriList = new ArrayList<String>();
        int namespaceCount = this.getNamespaceCount();
        if (namespaceCount == 0) {
            this.prefixList.add(null);
            this.uriList.add(null);
        }
        for (int i = 0; i < namespaceCount; ++i) {
            this.prefixList.add(this.checkString(this.getNamespacePrefix(i)));
            this.uriList.add(this.getNamespaceURI(i));
        }
        this.contextList.add(this.prefixList);
        this.contextList.add(this.uriList);
        this.context.push((ArrayList)this.contextList);
    }

    private String checkString(String namespacePrefix) {
        if (namespacePrefix == null) {
            return "";
        }
        return namespacePrefix;
    }

    public void popContext() throws XMLStreamException {
        this.context.pop();
    }

    public int next() throws XMLStreamException {
        int nextEvent;
        if (this.getEventType() == 2) {
            this.popContext();
        }
        if ((nextEvent = super.next()) == 1) {
            this.pushContext();
        }
        return nextEvent;
    }

    public int nextTag() throws XMLStreamException {
        if (this.getEventType() == 1) {
            this.pushContext();
        }
        if (this.getEventType() == 2) {
            this.popContext();
        }
        return super.nextTag();
    }

    public NamespaceContext getNamespaceContext() {
        return new TuscanyNamespaceContext((Stack)this.context.clone());
    }
}

