/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.net.URI;
import java.net.URL;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.UnrecognizedElementException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleURLArtifactProcessor
implements URLArtifactProcessor<Object> {
    private URLArtifactProcessorExtensionPoint processors;
    private Monitor monitor;

    public ExtensibleURLArtifactProcessor(URLArtifactProcessorExtensionPoint processors, Monitor monitor) {
        this.processors = processors;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public Object read(URL contributionURL, URI sourceURI, URL sourceURL) throws ContributionReadException {
        String extension;
        int extensionStart;
        URLArtifactProcessor processor = null;
        String fileName = ExtensibleURLArtifactProcessor.getFileName(sourceURL);
        processor = (URLArtifactProcessor)this.processors.getProcessor(fileName);
        if (processor == null && (extensionStart = (extension = sourceURL.getPath()).lastIndexOf(46)) > 0) {
            extension = extension.substring(extensionStart);
            processor = (URLArtifactProcessor)this.processors.getProcessor(extension);
        }
        if (processor == null) {
            return null;
        }
        return processor.read(contributionURL, sourceURI, sourceURL);
    }

    @Override
    public void resolve(Object model, ModelResolver resolver) throws ContributionResolveException {
        URLArtifactProcessor processor;
        if (model != null && (processor = (URLArtifactProcessor)this.processors.getProcessor(model.getClass())) != null) {
            processor.resolve(model, resolver);
        }
    }

    public <M> M read(URL contributionURL, URI artifactURI, URL artifactUrl, Class<M> type) throws ContributionReadException {
        Object mo = this.read(contributionURL, artifactURI, artifactUrl);
        if (type.isInstance(mo)) {
            return type.cast(mo);
        }
        UnrecognizedElementException e = new UnrecognizedElementException(null);
        e.setResourceURI(artifactURI.toString());
        this.error("UnrecognizedElementException", this.processors, artifactURI.toString());
        throw e;
    }

    @Override
    public String getArtifactType() {
        return null;
    }

    @Override
    public Class<Object> getModelType() {
        return null;
    }

    private static String getFileName(URL url) {
        String fileName = url.getPath();
        int pos = fileName.lastIndexOf("/");
        return fileName.substring(pos + 1);
    }
}

