/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleStAXAttributeProcessor
implements StAXAttributeProcessor<Object> {
    private static final Logger logger = Logger.getLogger(ExtensibleStAXAttributeProcessor.class.getName());
    private static final QName UNKNOWN_ATTRIBUTE = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "unknown");
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private StAXAttributeProcessorExtensionPoint processors;
    private Monitor monitor;

    public ExtensibleStAXAttributeProcessor(StAXAttributeProcessorExtensionPoint processors, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, Monitor monitor) {
        this.processors = processors;
        this.inputFactory = inputFactory;
        this.outputFactory = outputFactory;
        if (this.outputFactory != null) {
            this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
        this.monitor = monitor;
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public Object read(QName attributeName, XMLStreamReader source) throws ContributionReadException, XMLStreamException {
        Location location;
        int event = source.getEventType();
        if (event == 7) {
            source.nextTag();
        }
        StAXAttributeProcessor processor = null;
        processor = (StAXAttributeProcessor)this.processors.getProcessor(attributeName);
        if (processor == null) {
            location = source.getLocation();
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Attribute " + attributeName + " cannot be processed. (" + location + ")");
            }
        } else {
            return processor.read(attributeName, source);
        }
        this.warning("AttributeCannotBeProcessed", this.processors, attributeName, location);
        processor = (StAXAttributeProcessor)this.processors.getProcessor(UNKNOWN_ATTRIBUTE);
        if (processor == null) {
            location = source.getLocation();
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Could not find Default Attribute processor !");
            }
            this.warning("DefaultAttributeProcessorNotAvailable", this.processors, UNKNOWN_ATTRIBUTE, location);
        }
        return processor == null ? null : processor.read(attributeName, source);
    }

    @Override
    public void write(Object model, XMLStreamWriter outputSource) throws ContributionWriteException, XMLStreamException {
        if (model == null) {
            return;
        }
        StAXAttributeProcessor processor = (StAXAttributeProcessor)this.processors.getProcessor(model.getClass());
        if (processor == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("No StAX processor is configured to handle " + model.getClass());
            }
        } else {
            processor.write(model, outputSource);
            return;
        }
        this.warning("NoStaxProcessor", this.processors, model.getClass());
        processor = (StAXAttributeProcessor)this.processors.getProcessor(UNKNOWN_ATTRIBUTE);
        if (processor == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("No Default StAX processor is configured to handle " + model.getClass());
            }
        } else {
            processor.write(model, outputSource);
            return;
        }
        this.warning("NoDefaultStaxProcessor", this.processors, model.getClass());
    }

    @Override
    public void resolve(Object model, ModelResolver resolver) throws ContributionResolveException {
        StAXAttributeProcessor processor;
        if (model != null && (processor = (StAXAttributeProcessor)this.processors.getProcessor(model.getClass())) != null) {
            processor.resolve(model, resolver);
        }
    }

    public <M> M read(InputStream is, Class<M> type) throws ContributionReadException {
        return null;
    }

    public void write(Object model, OutputStream os) throws ContributionWriteException {
        try {
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(os);
            this.write(model, writer);
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException e) {
            ContributionWriteException cw = new ContributionWriteException(e);
            this.error("ContributionWriteException", (Object)this.outputFactory, cw);
            throw cw;
        }
    }

    @Override
    public QName getArtifactType() {
        return null;
    }

    @Override
    public Class<Object> getModelType() {
        return null;
    }
}

