/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.DefaultArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultURLArtifactProcessorExtensionPoint
extends DefaultArtifactProcessorExtensionPoint<URLArtifactProcessor>
implements URLArtifactProcessorExtensionPoint {
    private ExtensionPointRegistry extensionPoints;
    private StAXArtifactProcessor<?> staxProcessor;
    private boolean loaded;
    private Monitor monitor = null;

    public DefaultURLArtifactProcessorExtensionPoint(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        ModelFactoryExtensionPoint modelFactories = this.extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        XMLInputFactory inputFactory = modelFactories.getFactory(XMLInputFactory.class);
        XMLOutputFactory outputFactory = modelFactories.getFactory(XMLOutputFactory.class);
        UtilityExtensionPoint utilities = this.extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = utilities.getUtility(MonitorFactory.class);
        if (monitorFactory != null) {
            this.monitor = monitorFactory.createMonitor();
        }
        StAXArtifactProcessorExtensionPoint staxProcessors = extensionPoints.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.staxProcessor = new ExtensibleStAXArtifactProcessor(staxProcessors, inputFactory, outputFactory, this.monitor);
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public void addArtifactProcessor(URLArtifactProcessor artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            this.processorsByArtifactType.put(artifactProcessor.getArtifactType(), artifactProcessor);
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.put(artifactProcessor.getModelType(), artifactProcessor);
        }
    }

    @Override
    public void removeArtifactProcessor(URLArtifactProcessor artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            this.processorsByArtifactType.remove(artifactProcessor.getArtifactType());
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.remove(artifactProcessor.getModelType());
        }
    }

    @Override
    public URLArtifactProcessor getProcessor(Class<?> modelType) {
        this.loadProcessors();
        return (URLArtifactProcessor)super.getProcessor(modelType);
    }

    @Override
    public URLArtifactProcessor getProcessor(Object artifactType) {
        this.loadProcessors();
        return (URLArtifactProcessor)super.getProcessor(artifactType);
    }

    private void loadProcessors() {
        Set<ServiceDeclaration> processorDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            processorDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(URLArtifactProcessor.class);
        }
        catch (IOException e) {
            IllegalStateException ie = new IllegalStateException(e);
            this.error("IllegalStateException", this.staxProcessor, ie);
            throw ie;
        }
        for (ServiceDeclaration processorDeclaration : processorDeclarations) {
            Map<String, String> attributes = processorDeclaration.getAttributes();
            String artifactType = attributes.get("type");
            String modelTypeName = attributes.get("model");
            LazyURLArtifactProcessor processor = new LazyURLArtifactProcessor(artifactType, modelTypeName, processorDeclaration, this.extensionPoints, this.staxProcessor, this.monitor);
            this.addArtifactProcessor(processor);
        }
        this.loaded = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyURLArtifactProcessor
    implements URLArtifactProcessor {
        private ExtensionPointRegistry extensionPoints;
        private String artifactType;
        private String modelTypeName;
        private ServiceDeclaration processorDeclaration;
        private URLArtifactProcessor processor;
        private Class<?> modelType;
        private StAXArtifactProcessor<?> staxProcessor;
        private Monitor monitor;

        LazyURLArtifactProcessor(String artifactType, String modelTypeName, ServiceDeclaration processorDeclaration, ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<?> staxProcessor, Monitor monitor) {
            this.artifactType = artifactType;
            this.modelTypeName = modelTypeName;
            this.processorDeclaration = processorDeclaration;
            this.extensionPoints = extensionPoints;
            this.staxProcessor = staxProcessor;
            this.monitor = monitor;
        }

        @Override
        public String getArtifactType() {
            return this.artifactType;
        }

        private void error(String message, Object model, Exception ex) {
            if (this.monitor != null) {
                ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
                this.monitor.problem(problem);
            }
        }

        private URLArtifactProcessor getProcessor() {
            if (this.processor == null) {
                try {
                    ModelFactoryExtensionPoint modelFactories = this.extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
                    Class<?> processorClass = this.processorDeclaration.loadClass();
                    try {
                        Constructor<?> constructor = processorClass.getConstructor(ModelFactoryExtensionPoint.class, Monitor.class);
                        this.processor = (URLArtifactProcessor)constructor.newInstance(modelFactories, this.monitor);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Constructor<?> constructor = processorClass.getConstructor(ModelFactoryExtensionPoint.class, StAXArtifactProcessor.class, Monitor.class);
                            this.processor = (URLArtifactProcessor)constructor.newInstance(modelFactories, this.staxProcessor, this.monitor);
                        }
                        catch (NoSuchMethodException e2) {
                            Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class, StAXArtifactProcessor.class, Monitor.class);
                            this.processor = (URLArtifactProcessor)constructor.newInstance(this.extensionPoints, this.staxProcessor, this.monitor);
                        }
                    }
                }
                catch (Exception e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    this.error("IllegalStateException", this.processor, ie);
                    throw ie;
                }
            }
            return this.processor;
        }

        public Object read(URL contributionURL, URI artifactURI, URL artifactURL) throws ContributionReadException {
            return this.getProcessor().read(contributionURL, artifactURI, artifactURL);
        }

        @Override
        public Class<?> getModelType() {
            if (this.modelTypeName != null && this.modelType == null) {
                try {
                    this.modelType = this.processorDeclaration.loadClass(this.modelTypeName);
                }
                catch (ClassNotFoundException e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    this.error("IllegalStateException", this.processorDeclaration, ie);
                    throw ie;
                }
            }
            return this.modelType;
        }

        @Override
        public void resolve(Object model, ModelResolver resolver) throws ContributionResolveException {
            this.getProcessor().resolve(model, resolver);
        }
    }
}

