/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.DefaultArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStAXAttributeProcessorExtensionPoint
extends DefaultArtifactProcessorExtensionPoint<StAXAttributeProcessor>
implements StAXAttributeProcessorExtensionPoint {
    private ExtensionPointRegistry extensionPoints;
    private ModelFactoryExtensionPoint modelFactories;
    private StAXAttributeProcessor<Object> extensibleStAXAttributeProcessor;
    private boolean loaded;
    private Monitor monitor = null;

    public DefaultStAXAttributeProcessorExtensionPoint(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        XMLInputFactory inputFactory = this.modelFactories.getFactory(XMLInputFactory.class);
        XMLOutputFactory outputFactory = this.modelFactories.getFactory(XMLOutputFactory.class);
        UtilityExtensionPoint utilities = this.extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = utilities.getUtility(MonitorFactory.class);
        if (monitorFactory != null) {
            this.monitor = monitorFactory.createMonitor();
        }
        this.extensibleStAXAttributeProcessor = new ExtensibleStAXAttributeProcessor(this, inputFactory, outputFactory, this.monitor);
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public void addArtifactProcessor(StAXAttributeProcessor artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            this.processorsByArtifactType.put(artifactProcessor.getArtifactType(), artifactProcessor);
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.put(artifactProcessor.getModelType(), artifactProcessor);
        }
    }

    @Override
    public void removeArtifactProcessor(StAXAttributeProcessor artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            this.processorsByArtifactType.remove(artifactProcessor.getArtifactType());
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.remove(artifactProcessor.getModelType());
        }
    }

    @Override
    public StAXAttributeProcessor getProcessor(Class<?> modelType) {
        this.loadArtifactProcessors();
        return (StAXAttributeProcessor)super.getProcessor(modelType);
    }

    @Override
    public StAXAttributeProcessor getProcessor(Object artifactType) {
        this.loadArtifactProcessors();
        return (StAXAttributeProcessor)super.getProcessor(artifactType);
    }

    private static QName getQName(String qname) {
        if (qname == null) {
            return null;
        }
        if ((qname = qname.trim()).startsWith("{")) {
            int h = qname.indexOf(125);
            if (h != -1) {
                return new QName(qname.substring(1, h), qname.substring(h + 1));
            }
        } else {
            int h = qname.indexOf(35);
            if (h != -1) {
                return new QName(qname.substring(0, h), qname.substring(h + 1));
            }
        }
        throw new IllegalArgumentException("Invalid qname: " + qname);
    }

    private void loadArtifactProcessors() {
        Set<ServiceDeclaration> processorDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            processorDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(StAXAttributeProcessor.class);
        }
        catch (IOException e) {
            IllegalStateException ie = new IllegalStateException(e);
            this.error("IllegalStateException", this.extensibleStAXAttributeProcessor, ie);
            throw ie;
        }
        for (ServiceDeclaration processorDeclaration : processorDeclarations) {
            Map<String, String> attributes = processorDeclaration.getAttributes();
            QName artifactType = DefaultStAXAttributeProcessorExtensionPoint.getQName(attributes.get("qname"));
            String modelTypeName = attributes.get("model");
            String factoryName = attributes.get("factory");
            LazyStAXAttributeProcessor processor = new LazyStAXAttributeProcessor(artifactType, modelTypeName, factoryName, processorDeclaration, this.extensionPoints, this.modelFactories, this.extensibleStAXAttributeProcessor, this.monitor);
            this.addArtifactProcessor(processor);
        }
        this.loaded = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyStAXAttributeProcessor
    implements StAXAttributeProcessor {
        private ExtensionPointRegistry extensionPoints;
        private QName artifactType;
        private String modelTypeName;
        private String factoryName;
        private ServiceDeclaration processorDeclaration;
        private StAXAttributeProcessor processor;
        private Class<?> modelType;
        private StAXAttributeProcessor<Object> extensionProcessor;
        private Monitor monitor;

        LazyStAXAttributeProcessor(QName artifactType, String modelTypeName, String factoryName, ServiceDeclaration processorDeclaration, ExtensionPointRegistry extensionPoints, ModelFactoryExtensionPoint modelFactories, StAXAttributeProcessor<Object> extensionProcessor, Monitor monitor) {
            this.extensionPoints = extensionPoints;
            this.artifactType = artifactType;
            this.modelTypeName = modelTypeName;
            this.factoryName = factoryName;
            this.processorDeclaration = processorDeclaration;
            this.extensionProcessor = extensionProcessor;
            this.monitor = monitor;
        }

        @Override
        public QName getArtifactType() {
            return this.artifactType;
        }

        private void error(String message, Object model, Exception ex) {
            if (this.monitor != null) {
                ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
                this.monitor.problem(problem);
            }
        }

        private StAXAttributeProcessor getProcessor() {
            if (this.processor == null) {
                ModelFactoryExtensionPoint modelFactories = this.extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
                try {
                    Class<?> processorClass = this.processorDeclaration.loadClass();
                    try {
                        Constructor<?> constructor = processorClass.getConstructor(ModelFactoryExtensionPoint.class, Monitor.class);
                        this.processor = (StAXAttributeProcessor)constructor.newInstance(modelFactories, this.monitor);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class, Monitor.class);
                            this.processor = (StAXAttributeProcessor)constructor.newInstance(this.extensionPoints, this.monitor);
                        }
                        catch (NoSuchMethodException e1) {
                            try {
                                Constructor<?> constructor = processorClass.getConstructor(ModelFactoryExtensionPoint.class, StAXArtifactProcessor.class, Monitor.class);
                                this.processor = (StAXAttributeProcessor)constructor.newInstance(modelFactories, this.extensionProcessor, this.monitor);
                            }
                            catch (NoSuchMethodException e2) {
                                try {
                                    Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class, StAXArtifactProcessor.class, Monitor.class);
                                    this.processor = (StAXAttributeProcessor)constructor.newInstance(this.extensionPoints, this.extensionProcessor, this.monitor);
                                }
                                catch (NoSuchMethodException e3) {
                                    try {
                                        Constructor<?> constructor = processorClass.getConstructor(ModelFactoryExtensionPoint.class);
                                        this.processor = (StAXAttributeProcessor)constructor.newInstance(modelFactories);
                                    }
                                    catch (NoSuchMethodException e4) {
                                        try {
                                            Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class);
                                            this.processor = (StAXAttributeProcessor)constructor.newInstance(this.extensionPoints);
                                        }
                                        catch (NoSuchMethodException e4a) {
                                            try {
                                                Constructor<?> constructor = processorClass.getConstructor(ModelFactoryExtensionPoint.class, StAXArtifactProcessor.class);
                                                this.processor = (StAXAttributeProcessor)constructor.newInstance(modelFactories, this.extensionProcessor);
                                            }
                                            catch (NoSuchMethodException e5) {
                                                Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class, StAXArtifactProcessor.class);
                                                this.processor = (StAXAttributeProcessor)constructor.newInstance(this.extensionPoints, this.extensionProcessor);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    this.error("IllegalStateException", this.processor, ie);
                    throw ie;
                }
            }
            return this.processor;
        }

        public Object read(QName attributeName, XMLStreamReader inputSource) throws ContributionReadException, XMLStreamException {
            return this.getProcessor().read(attributeName, inputSource);
        }

        public void write(Object model, XMLStreamWriter outputSource) throws ContributionWriteException, XMLStreamException {
            this.getProcessor().write(model, outputSource);
        }

        @Override
        public Class<?> getModelType() {
            if (this.modelTypeName != null && this.modelType == null) {
                try {
                    this.modelType = this.processorDeclaration.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    this.error("IllegalStateException", this.processorDeclaration, ie);
                    throw ie;
                }
            }
            return this.modelType;
        }

        @Override
        public void resolve(Object model, ModelResolver resolver) throws ContributionResolveException {
            this.getProcessor().resolve(model, resolver);
        }
    }
}

