/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.osgi.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.osgi.impl.OSGiBundleProcessor;
import org.apache.tuscany.sca.contribution.service.ContributionListener;
import org.apache.tuscany.sca.contribution.service.ContributionRepository;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;

public class OSGiImportExportListener
implements ContributionListener {
    private OSGiBundleProcessor bundleProcessor = new OSGiBundleProcessor();

    public void contributionAdded(ContributionRepository repository, Contribution contribution) {
        OSGiRuntime osgiRuntime = null;
        try {
            if (this.bundleProcessor.installContributionBundle(contribution) == null) {
                return;
            }
            osgiRuntime = OSGiRuntime.getRuntime();
        }
        catch (Exception e) {
            return;
        }
        HashSet<Contribution> bundlesToInstall = new HashSet<Contribution>();
        for (Import import_ : contribution.getImports()) {
            boolean initialized = false;
            if (import_ instanceof JavaImport) {
                Contribution targetContribution;
                JavaImport javaImport = (JavaImport)import_;
                String packageName = javaImport.getPackage();
                if (javaImport.getLocation() != null && (targetContribution = repository.getContribution(javaImport.getLocation())) != null) {
                    for (Export export : targetContribution.getExports()) {
                        JavaExport javaExport;
                        if (export instanceof JavaExport && packageName.equals((javaExport = (JavaExport)export).getPackage())) {
                            if (osgiRuntime.findBundle(targetContribution.getLocation()) == null) {
                                bundlesToInstall.add(targetContribution);
                            }
                            initialized = true;
                        }
                        if (!initialized) continue;
                        break;
                    }
                }
            }
            if (initialized) continue;
            for (Contribution c : repository.getContributions()) {
                for (Export export : c.getExports()) {
                    if (!import_.match(export) || osgiRuntime.findBundle(c.getLocation()) != null) continue;
                    bundlesToInstall.add(c);
                }
            }
        }
        for (Contribution c : bundlesToInstall) {
            try {
                this.installDummyBundle(osgiRuntime, c);
            }
            catch (Exception e) {}
        }
    }

    public void contributionRemoved(ContributionRepository repository, Contribution contribution) {
    }

    public void contributionUpdated(ContributionRepository repository, Contribution oldContribution, Contribution contribution) {
    }

    private void installDummyBundle(OSGiRuntime osgiRuntime, Contribution contribution) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String EOL = System.getProperty("line.separator");
        String bundleName = contribution.getURI();
        URL contribURL = new URL(contribution.getLocation());
        String contribName = contribURL.getPath();
        if (contribName.endsWith("/")) {
            contribName = contribName.substring(0, contribName.length() - 1);
        }
        if (contribName.lastIndexOf("/") >= 0) {
            contribName = contribName.substring(contribName.lastIndexOf("/") + 1);
        }
        StringBuffer exportPackageNames = new StringBuffer();
        for (Export export : contribution.getExports()) {
            if (!(export instanceof JavaExport)) continue;
            if (exportPackageNames.length() > 0) {
                exportPackageNames.append(",");
            }
            exportPackageNames.append(((JavaExport)export).getPackage());
        }
        StringBuffer importPackageNames = new StringBuffer();
        for (Import import_ : contribution.getImports()) {
            if (!(import_ instanceof JavaImport)) continue;
            if (importPackageNames.length() > 0) {
                importPackageNames.append(",");
            }
            importPackageNames.append(((JavaImport)import_).getPackage());
        }
        String manifestStr = "Manifest-Version: 1.0" + EOL + "Bundle-ManifestVersion: 2" + EOL + "Bundle-Name: " + bundleName + EOL + "Bundle-SymbolicName: " + bundleName + EOL + "Bundle-Version: " + "1.0.0" + EOL + "Bundle-Localization: plugin" + EOL;
        StringBuilder manifestBuf = new StringBuilder();
        manifestBuf.append(manifestStr);
        manifestBuf.append("Export-Package: " + exportPackageNames + EOL);
        manifestBuf.append("Import-Package: " + importPackageNames + EOL);
        manifestBuf.append("Bundle-ClassPath: .," + contribName + EOL);
        ByteArrayInputStream manifestStream = new ByteArrayInputStream(manifestBuf.toString().getBytes());
        Manifest manifest = new Manifest();
        manifest.read(manifestStream);
        JarOutputStream jarOut = new JarOutputStream((OutputStream)out, manifest);
        ZipEntry ze = new ZipEntry(contribName);
        jarOut.putNextEntry(ze);
        InputStream stream = contribURL.openStream();
        byte[] bytes = new byte[stream.available()];
        stream.read(bytes);
        jarOut.write(bytes);
        stream.close();
        jarOut.close();
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        osgiRuntime.installBundle("file://" + bundleName + ".jar", in);
    }
}

