/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.osgi.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiClassReferenceModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<String, ClassReference> map = new HashMap<String, ClassReference>();
    private Bundle bundle;
    private boolean initialized;
    private boolean useOSGi;

    public OSGiClassReferenceModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    @Override
    public void addModel(Object resolved) {
        ClassReference clazz = (ClassReference)resolved;
        this.map.put(clazz.getClassName(), clazz);
    }

    @Override
    public Object removeModel(Object resolved) {
        return this.map.remove(((ClassReference)resolved).getClassName());
    }

    private ClassReference resolveImportedModel(ClassReference unresolved) {
        ClassReference resolved = unresolved;
        if (this.contribution != null) {
            for (Import import_ : this.contribution.getImports()) {
                if (resolved != unresolved || this.bundle == null || (resolved = import_.getModelResolver().resolveModel(ClassReference.class, unresolved)) == unresolved) continue;
                break;
            }
        }
        return resolved;
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        ClassReference resolved = this.map.get(unresolved);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        this.initialize();
        if (!this.useOSGi) {
            return unresolved;
        }
        Class clazz = null;
        if (this.bundle != null) {
            try {
                clazz = this.bundle.loadClass(((ClassReference)unresolved).getClassName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            ClassReference classReference = new ClassReference(clazz);
            this.map.put(this.getPackageName(classReference), classReference);
            return modelClass.cast(classReference);
        }
        resolved = this.resolveImportedModel((ClassReference)unresolved);
        return modelClass.cast(resolved);
    }

    private String getPackageName(ClassReference clazz) {
        int pos = clazz.getClassName().lastIndexOf(".");
        return clazz.getClassName().substring(0, pos - 1);
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            this.bundle = OSGiRuntime.findInstalledBundle(this.contribution.getLocation());
            this.useOSGi = this.bundle != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

