/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.osgi.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.osgi.BundleReference;
import org.apache.tuscany.sca.contribution.osgi.impl.OSGiBundleProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundleReferenceModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<String, BundleReference> map = new HashMap<String, BundleReference>();
    OSGiRuntime osgiRuntime;
    private OSGiBundleProcessor bundleProcessor;

    public OSGiBundleReferenceModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
        this.bundleProcessor = new OSGiBundleProcessor();
    }

    @Override
    public void addModel(Object resolved) {
        BundleReference bundleRef = (BundleReference)resolved;
        this.map.put(bundleRef.getBundleUniqueName(), bundleRef);
    }

    @Override
    public Object removeModel(Object resolved) {
        return this.map.remove(((BundleReference)resolved).getBundleUniqueName());
    }

    private BundleReference resolveImportedModel(BundleReference unresolved) {
        BundleReference resolved;
        block1: {
            Import import_;
            resolved = unresolved;
            if (this.contribution == null) break block1;
            Iterator<Import> i$ = this.contribution.getImports().iterator();
            while (i$.hasNext() && (resolved = (import_ = i$.next()).getModelResolver().resolveModel(BundleReference.class, unresolved)) == unresolved) {
            }
        }
        return resolved;
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        String bundleVersion;
        BundleReference resolved = this.map.get(unresolved);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        try {
            if (this.osgiRuntime == null) {
                this.osgiRuntime = OSGiRuntime.getRuntime();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.osgiRuntime == null) {
            return unresolved;
        }
        Bundle bundle = null;
        String bundleName = ((BundleReference)unresolved).getBundleName();
        bundle = this.osgiRuntime.findBundle(bundleName, bundleVersion = ((BundleReference)unresolved).getBundleVersion());
        BundleReference bundleReference = bundle == null ? this.bundleProcessor.installNestedBundle(this.contribution, bundleName, bundleVersion) : new BundleReference(bundle, ((BundleReference)unresolved).getBundleName(), bundleVersion, this.getBundleFileName(bundle));
        if (bundleReference != null) {
            this.map.put(((BundleReference)unresolved).getBundleUniqueName(), bundleReference);
            return modelClass.cast(bundleReference);
        }
        resolved = this.resolveImportedModel((BundleReference)unresolved);
        return modelClass.cast(resolved);
    }

    private String getBundleFileName(Object bundle) {
        if (bundle instanceof Bundle) {
            String path = ((Bundle)bundle).getLocation();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.startsWith(this.contribution.getLocation())) {
                if (path.equals(this.contribution.getLocation())) {
                    int index = path.lastIndexOf(47);
                    if (index > 0 && index < path.length() - 1) {
                        path = path.substring(index + 1);
                    }
                } else if ((path = path.substring(this.contribution.getLocation().length())).startsWith("/")) {
                    path = path.substring(1);
                }
            } else if (path.lastIndexOf(47) >= 0) {
                path = path.substring(path.lastIndexOf(47) + 1);
            }
            return path;
        }
        return null;
    }
}

