/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.osgi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.tuscany.sca.contribution.processor.PackageProcessor;
import org.apache.tuscany.sca.contribution.service.ContributionException;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundleContributionProcessor
implements PackageProcessor {
    @Override
    public String getPackageType() {
        return "application/osgi.bundle";
    }

    @Override
    public URL getArtifactURL(URL sourceURL, URI artifact) throws MalformedURLException {
        Bundle bundle = null;
        try {
            bundle = OSGiRuntime.findInstalledBundle(sourceURL);
            if (bundle != null) {
                URL url = bundle.getResource(artifact.getPath());
                if (url == null) {
                    System.out.println("Could not load resource " + artifact);
                }
                return url;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URI> getJarArtifacts(URL packageSourceURL, InputStream inputStream) throws ContributionException, IOException {
        if (packageSourceURL == null) {
            throw new IllegalArgumentException("Invalid null package source URL.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid null source inputstream.");
        }
        JarInputStream jar = new JarInputStream(inputStream);
        try {
            JarEntry entry;
            HashSet<String> names = new HashSet<String>();
            while ((entry = jar.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (name.startsWith(".") || entry.isDirectory()) continue;
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (names.contains(name) || name.length() <= 0) continue;
                names.add(name);
            }
            ArrayList<URI> artifacts = new ArrayList<URI>();
            for (String name : names) {
                artifacts.add(URI.create(name));
            }
            ArrayList<URI> arrayList = artifacts;
            return arrayList;
        }
        finally {
            jar.close();
        }
    }

    @Override
    public List<URI> getArtifacts(URL packageSourceURL, InputStream inputStream) throws ContributionException, IOException {
        Bundle bundle = null;
        try {
            bundle = OSGiRuntime.findInstalledBundle(packageSourceURL);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Could not find OSGi bundle " + packageSourceURL);
        }
        if (packageSourceURL == null) {
            throw new IllegalArgumentException("Invalid null package source URL.");
        }
        ArrayList<URI> artifacts = new ArrayList<URI>();
        try {
            Enumeration entries = bundle.findEntries("/", "*", true);
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                String entryName = entry.getPath();
                if (entryName.startsWith("/")) {
                    entryName = entryName.substring(1);
                }
                artifacts.add(new URI(entryName));
                if (!entryName.endsWith(".jar")) continue;
                URL jarResource = bundle.getResource(entryName);
                artifacts.addAll(this.getJarArtifacts(jarResource, jarResource.openStream()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return artifacts;
    }
}

