/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelFactoryExtensionPoint
implements ModelFactoryExtensionPoint {
    private HashMap<Class<?>, Object> factories = new HashMap();

    @Override
    public void addFactory(Object factory) {
        Class<?>[] interfaces = factory.getClass().getInterfaces();
        if (interfaces.length == 0) {
            Class<?> sc = factory.getClass().getSuperclass();
            if (sc != Object.class) {
                this.factories.put(sc, factory);
            }
        } else {
            for (int i = 0; i < interfaces.length; ++i) {
                this.factories.put(interfaces[i], factory);
            }
        }
    }

    @Override
    public void removeFactory(Object factory) {
        Class<?>[] interfaces = factory.getClass().getInterfaces();
        if (interfaces.length == 0) {
            Class<?> sc = factory.getClass().getSuperclass();
            if (sc != Object.class) {
                this.factories.remove(sc);
            }
        } else {
            for (int i = 0; i < interfaces.length; ++i) {
                this.factories.remove(interfaces[i]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T getFactory(Class<T> factoryInterface) {
        Object factory = this.factories.get(factoryInterface);
        if (factory != null) return factoryInterface.cast(factory);
        if (factoryInterface.isInterface()) {
            try {
                Class<?> factoryClass = ServiceDiscovery.getInstance().loadFirstServiceClass(factoryInterface);
                if (factoryClass == null) return factoryInterface.cast(factory);
                try {
                    Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
                    factory = constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    Constructor<?> constructor = factoryClass.getConstructor(ModelFactoryExtensionPoint.class);
                    factory = constructor.newInstance(this);
                }
                this.addFactory(factory);
                return factoryInterface.cast(factory);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            factory = ServiceDiscovery.getInstance().newFactoryClassInstance(factoryInterface);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.addFactory(factory);
        return factoryInterface.cast(factory);
    }
}

