/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.context;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.tuscany.sca.context.ContextFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContextFactoryExtensionPoint
implements ContextFactoryExtensionPoint {
    private HashMap<Class<?>, Object> factories = new HashMap();
    private ExtensionPointRegistry registry;

    public DefaultContextFactoryExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addFactory(Object factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot add null as a factory");
        }
        Class<?>[] interfaces = factory.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.factories.put(interfaces[i], factory);
        }
    }

    @Override
    public void removeFactory(Object factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot remove null as a factory");
        }
        Class<?>[] interfaces = factory.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.factories.remove(interfaces[i]);
        }
    }

    @Override
    public <T> T getFactory(Class<T> factoryInterface) throws IllegalArgumentException {
        if (factoryInterface == null) {
            throw new IllegalArgumentException("Cannot get null as a factory");
        }
        Object factory = this.factories.get(factoryInterface);
        if (factory == null) {
            try {
                Class<?> factoryClass = ServiceDiscovery.getInstance().loadFirstServiceClass(factoryInterface);
                if (factoryClass != null) {
                    Constructor<?> constructor = factoryClass.getConstructor(ExtensionPointRegistry.class);
                    factory = constructor.newInstance(this.registry);
                    this.addFactory(factory);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return factoryInterface.cast(factory);
    }
}

