/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.configuration;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.tuscany.sca.binding.ws.axis2.policy.configuration.Axis2ConfigParamPolicy;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2ConfigParamPolicyProcessor
implements StAXArtifactProcessor<Axis2ConfigParamPolicy> {
    public static final QName AXIS2_CONFIG_PARAM_POLICY_QNAME = Axis2ConfigParamPolicy.NAME;
    public static final String PARAMETER = "parameter";

    @Override
    public QName getArtifactType() {
        return AXIS2_CONFIG_PARAM_POLICY_QNAME;
    }

    public Axis2ConfigParamPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    @Override
    public Axis2ConfigParamPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        Axis2ConfigParamPolicy policy = new Axis2ConfigParamPolicy();
        int event = reader.getEventType();
        QName name = null;
        OMElement parameterElement = null;
        String paramName = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (!PARAMETER.equals(name.getLocalPart())) break;
                    paramName = reader.getAttributeValue(null, "name");
                    parameterElement = this.loadElement(reader);
                    policy.getParamElements().put(paramName, parameterElement);
                }
            }
            if (event == 2 && AXIS2_CONFIG_PARAM_POLICY_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    @Override
    public void write(Axis2ConfigParamPolicy arg0, XMLStreamWriter arg1) throws ContributionWriteException, XMLStreamException {
    }

    @Override
    public Class<Axis2ConfigParamPolicy> getModelType() {
        return Axis2ConfigParamPolicy.class;
    }

    @Override
    public void resolve(Axis2ConfigParamPolicy arg0, ModelResolver arg1) throws ContributionResolveException {
    }

    private OMElement loadElement(XMLStreamReader reader) throws XMLStreamException {
        OMElement head;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement current = head = fac.createOMElement(reader.getName());
        while (true) {
            switch (reader.next()) {
                case 1: {
                    int i;
                    QName name = new QName(reader.getName().getLocalPart());
                    OMElement child = fac.createOMElement(name, (OMContainer)current);
                    int count = reader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        String ns = reader.getNamespaceURI(i);
                        child.declareNamespace(ns, prefix);
                    }
                    if (!"".equals(name.getNamespaceURI())) {
                        child.declareNamespace(name.getNamespaceURI(), name.getPrefix());
                    }
                    count = reader.getAttributeCount();
                    for (i = 0; i < count; ++i) {
                        String ns = reader.getAttributeNamespace(i);
                        String prefix = reader.getAttributePrefix(i);
                        String qname = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (ns != null) {
                            child.addAttribute(qname, value, fac.createOMNamespace(ns, prefix));
                            child.declareNamespace(ns, prefix);
                            continue;
                        }
                        child.addAttribute(qname, value, null);
                    }
                    current = child;
                    break;
                }
                case 12: {
                    fac.createOMText((OMContainer)current, reader.getText());
                    break;
                }
                case 4: {
                    fac.createOMText((OMContainer)current, reader.getText());
                    break;
                }
                case 2: {
                    if (current == head) {
                        return head;
                    }
                    current = (OMElement)current.getParent();
                }
            }
        }
    }
}

