/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token;

import javax.security.auth.Subject;
import org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token.Axis2TokenAuthenticationPolicy;
import org.apache.tuscany.sca.binding.ws.axis2.policy.header.Axis2HeaderPolicyUtil;
import org.apache.tuscany.sca.binding.ws.axis2.policy.header.Axis2SOAPHeaderString;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.SecurityUtil;
import org.apache.tuscany.sca.policy.authentication.token.TokenPrincipal;

public class Axis2TokenAuthenticationServicePolicyInterceptor
implements Interceptor {
    private Invoker next;
    private Operation operation;
    private PolicySet policySet = null;
    private String context;
    private Axis2TokenAuthenticationPolicy policy;

    public Axis2TokenAuthenticationServicePolicyInterceptor(String context, Operation operation, PolicySet policySet) {
        this.operation = operation;
        this.policySet = policySet;
        this.context = context;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            for (Object policyObject : this.policySet.getPolicies()) {
                if (!(policyObject instanceof Axis2TokenAuthenticationPolicy)) continue;
                this.policy = (Axis2TokenAuthenticationPolicy)policyObject;
                break;
            }
        }
    }

    public Message invoke(Message msg) {
        Axis2SOAPHeaderString header = (Axis2SOAPHeaderString)Axis2HeaderPolicyUtil.getHeader(msg, this.policy.getTokenName());
        if (header != null) {
            System.out.println("Web service received token: " + header.getHeaderString());
            Subject subject = SecurityUtil.getSubject(msg);
            TokenPrincipal principal = new TokenPrincipal(header.getHeaderString());
            subject.getPrincipals().add(principal);
        }
        return this.getNext().invoke(msg);
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

