/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token;

import org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token.Axis2TokenAuthenticationPolicy;
import org.apache.tuscany.sca.binding.ws.axis2.policy.header.Axis2SOAPHeaderString;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.PolicySet;

public class Axis2TokenAuthenticationReferencePolicyInterceptor
implements Interceptor {
    private Invoker next;
    private Operation operation;
    private PolicySet policySet = null;
    private String context;
    private Axis2TokenAuthenticationPolicy policy;

    public Axis2TokenAuthenticationReferencePolicyInterceptor(String context, Operation operation, PolicySet policySet) {
        this.operation = operation;
        this.policySet = policySet;
        this.context = context;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            for (Object policyObject : this.policySet.getPolicies()) {
                if (!(policyObject instanceof Axis2TokenAuthenticationPolicy)) continue;
                this.policy = (Axis2TokenAuthenticationPolicy)policyObject;
                break;
            }
        }
    }

    public Message invoke(Message msg) {
        if (this.policy.getTokenName() != null) {
            Axis2SOAPHeaderString header = new Axis2SOAPHeaderString();
            header.setHeaderName(this.policy.getTokenName());
            header.setHeaderString("SomeWSAuthorizationToken");
            msg.getHeaders().add(header);
        }
        return this.getNext().invoke(msg);
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

