/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.provider.SCADefinitionsProvider;
import org.apache.tuscany.sca.provider.SCADefinitionsProviderException;

public class WSBindingDefinitionsProvider
implements SCADefinitionsProvider {
    private String definitionsFile = "org/apache/tuscany/sca/binding/ws/axis2/definitions.xml";
    URLArtifactProcessor urlArtifactProcessor = null;

    public WSBindingDefinitionsProvider(ExtensionPointRegistry registry) {
        URLArtifactProcessorExtensionPoint documentProcessors = registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.urlArtifactProcessor = (URLArtifactProcessor)documentProcessors.getProcessor(SCADefinitions.class);
    }

    public SCADefinitions getSCADefinition() throws SCADefinitionsProviderException {
        final URL definitionsFileUrl = this.getClass().getClassLoader().getResource(this.definitionsFile);
        SCADefinitions scaDefn = null;
        try {
            final URI uri = new URI(this.definitionsFile);
            scaDefn = AccessController.doPrivileged(new PrivilegedExceptionAction<SCADefinitions>(){

                @Override
                public SCADefinitions run() throws ContributionReadException {
                    return (SCADefinitions)WSBindingDefinitionsProvider.this.urlArtifactProcessor.read(null, uri, definitionsFileUrl);
                }
            });
        }
        catch (Exception e) {
            throw new SCADefinitionsProviderException(e);
        }
        return scaDefn;
    }
}

