/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceProvider;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.policy.util.PolicyHandler;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2ServiceInOutSyncMessageReceiver
extends AbstractInOutSyncMessageReceiver {
    private static final Logger logger = Logger.getLogger(Axis2ServiceInOutSyncMessageReceiver.class.getName());
    protected Operation operation;
    private List<PolicyHandler> policyHandlerList = null;
    private Axis2ServiceProvider provider;

    public Axis2ServiceInOutSyncMessageReceiver(Axis2ServiceProvider provider, Operation operation, List<PolicyHandler> policyHandlerList) {
        this.provider = provider;
        this.operation = operation;
        this.policyHandlerList = policyHandlerList;
    }

    public Axis2ServiceInOutSyncMessageReceiver() {
    }

    public void invokeBusinessLogic(MessageContext inMC, MessageContext outMC) throws AxisFault {
        try {
            OMElement requestOM = inMC.getEnvelope().getBody().getFirstElement();
            Object[] args = null;
            if (requestOM != null) {
                args = new Object[]{requestOM};
            }
            OMElement responseOM = (OMElement)this.provider.invokeTarget(this.operation, args, inMC);
            SOAPEnvelope soapEnvelope = this.getSOAPFactory(inMC).getDefaultEnvelope();
            if (null != responseOM) {
                soapEnvelope.getBody().addChild((OMNode)responseOM);
            }
            outMC.setEnvelope(soapEnvelope);
            outMC.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof FaultException && ((FaultException)t).getFaultInfo() instanceof OMElement) {
                OMElement faultDetail = (OMElement)((FaultException)t).getFaultInfo();
                inMC.setProperty("faultName", (Object)faultDetail.getQName().getLocalPart());
                AxisFault f = new AxisFault(null, e.getMessage(), "faultNode", "faultRole", faultDetail);
                throw f;
            }
            if (t instanceof Exception) {
                throw AxisFault.makeFault((Throwable)((Exception)t));
            }
            logger.log(Level.SEVERE, e.getMessage(), t);
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

