/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceClient;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2ReferenceBindingProvider
implements ReferenceBindingProvider {
    private WebServiceBinding wsBinding;
    private Axis2ServiceClient axisClient;

    public Axis2ReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, WebServiceBinding wsBinding, ModelFactoryExtensionPoint modelFactories, List<PolicyHandlerTuple> policyHandlerClassnames, DataBindingExtensionPoint dataBindings) {
        MessageFactory messageFactory = modelFactories.getFactory(MessageFactory.class);
        this.wsBinding = wsBinding;
        if (wsBinding.getWSDLDocument() == null) {
            throw new ServiceRuntimeException("No WSDL document for " + component.getName() + "/" + reference.getName());
        }
        InterfaceContract contract = wsBinding.getBindingInterfaceContract();
        if (contract.getInterface() != null) {
            contract.getInterface().resetDataBinding(OMElement.class.getName());
        }
        this.axisClient = new Axis2ServiceClient(component, reference, wsBinding, messageFactory, policyHandlerClassnames);
    }

    @Override
    public void start() {
        this.axisClient.start();
    }

    @Override
    public void stop() {
        this.axisClient.stop();
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return true;
    }

    @Override
    public Invoker createInvoker(Operation operation) {
        return this.axisClient.createInvoker(operation);
    }
}

