/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.IntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCABindingProcessor
implements StAXArtifactProcessor<SCABinding>,
Constants {
    private PolicyFactory policyFactory;
    private SCABindingFactory scaBindingFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private IntentAttachPointTypeFactory intentAttachPointTypeFactory;
    private Monitor monitor;
    protected static final String BINDING_SCA = "binding.sca";
    protected static final QName BINDING_SCA_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "binding.sca");

    public SCABindingProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.scaBindingFactory = modelFactories.getFactory(SCABindingFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.intentAttachPointTypeFactory = modelFactories.getFactory(IntentAttachPointTypeFactory.class);
        this.monitor = monitor;
    }

    @Override
    public QName getArtifactType() {
        return BINDING_SCA_QNAME;
    }

    @Override
    public Class<SCABinding> getModelType() {
        return SCABinding.class;
    }

    @Override
    public SCABinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String uri;
        SCABinding scaBinding = this.scaBindingFactory.createSCABinding();
        IntentAttachPointType bindingType = this.intentAttachPointTypeFactory.createBindingType();
        bindingType.setName(this.getArtifactType());
        bindingType.setUnresolved(true);
        ((PolicySetAttachPoint)((Object)scaBinding)).setType(bindingType);
        this.policyProcessor.readPolicies(scaBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            scaBinding.setName(name);
        }
        if ((uri = reader.getAttributeValue(null, "uri")) != null) {
            scaBinding.setURI(uri);
        }
        while (reader.hasNext() && (reader.next() != 2 || !BINDING_SCA_QNAME.equals(reader.getName()))) {
        }
        return scaBinding;
    }

    @Override
    public void resolve(SCABinding model, ModelResolver resolver) throws ContributionResolveException {
        this.policyProcessor.resolvePolicies(model, resolver);
    }

    @Override
    public void write(SCABinding scaBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.policyProcessor.writePolicyPrefixes(scaBinding, writer);
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", BINDING_SCA);
        this.policyProcessor.writePolicyAttributes(scaBinding, writer);
        if (scaBinding.getName() != null) {
            writer.writeAttribute("name", scaBinding.getName());
        }
        if (scaBinding.getURI() != null) {
            writer.writeAttribute("uri", scaBinding.getURI());
        }
        writer.writeEndElement();
    }
}

