/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rss.provider;

import javax.servlet.Servlet;
import org.apache.tuscany.sca.binding.rss.RSSBinding;
import org.apache.tuscany.sca.binding.rss.provider.RSSBindingListenerServlet;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

class RSSServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponentService service;
    private RSSBinding binding;
    private ServletHost servletHost;
    private MessageFactory messageFactory;
    private String servletMapping;
    private Mediator mediator;

    RSSServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, RSSBinding binding, ServletHost servletHost, MessageFactory messageFactory, Mediator mediator) {
        this.service = service;
        this.binding = binding;
        this.servletHost = servletHost;
        this.messageFactory = messageFactory;
        this.mediator = mediator;
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        RuntimeComponentService componentService = this.service;
        RuntimeWire wire = componentService.getRuntimeWire(this.binding);
        RSSBindingListenerServlet servlet = new RSSBindingListenerServlet(wire, this.messageFactory, this.mediator);
        this.servletMapping = this.binding.getURI();
        this.servletHost.addServletMapping(this.servletMapping, (Servlet)servlet);
        this.binding.setURI(this.servletHost.getURLMapping(this.binding.getURI()).toString());
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
    }
}

