/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rss.provider;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

class RSSBindingInvoker
implements Invoker,
DataExchangeSemantics {
    private static final Logger logger = Logger.getLogger(RSSBindingInvoker.class.getName());
    private String uri;

    RSSBindingInvoker(String uri, String feedType) {
        this.uri = uri;
    }

    public Message invoke(Message msg) {
        try {
            logger.fine("invoke " + this.uri);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)new XmlReader(new URL(this.uri)));
            msg.setBody(feed);
        }
        catch (MalformedURLException e) {
            msg.setFaultBody(e);
        }
        catch (IllegalArgumentException e) {
            msg.setFaultBody(e);
        }
        catch (FeedException e) {
            msg.setFaultBody(e);
        }
        catch (IOException e) {
            msg.setFaultBody(e);
        }
        return msg;
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

