/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rmi.provider;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import net.sf.cglib.asm.ClassWriter;
import net.sf.cglib.asm.Type;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.tuscany.sca.binding.rmi.RMIBinding;
import org.apache.tuscany.sca.host.rmi.RMIHost;
import org.apache.tuscany.sca.host.rmi.RMIHostException;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private RMIBinding binding;
    private RMIHost rmiHost;
    private RuntimeWire wire;

    public RMIServiceBindingProvider(RuntimeComponent rc, RuntimeComponentService rcs, RMIBinding binding, RMIHost rmiHost) {
        this.component = rc;
        this.service = rcs;
        this.binding = binding;
        this.rmiHost = rmiHost;
    }

    @Override
    public void start() {
        this.wire = this.service.getRuntimeWire(this.binding);
        Interface serviceInterface = this.service.getInterfaceContract().getInterface();
        Remote rmiProxy = this.createRmiService(serviceInterface);
        try {
            this.rmiHost.registerService(this.binding.getServiceName(), this.getPort(this.binding.getPort()), rmiProxy);
        }
        catch (RMIHostException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public void stop() {
        this.rmiHost.unregisterService(this.binding.getServiceName(), this.getPort(this.binding.getPort()));
    }

    protected int getPort(String port) {
        int portNumber = 1099;
        if (port != null && port.length() > 0 && (portNumber = Integer.decode(port).intValue()) == -1) {
            portNumber = 1099;
        }
        return portNumber;
    }

    protected Remote createRmiService(final Interface serviceInterface) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(UnicastRemoteObject.class);
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object arg0, Method method, Object[] args, MethodProxy arg3) throws Throwable {
                try {
                    return RMIServiceBindingProvider.this.invokeTarget(JavaInterfaceUtil.findOperation(method, serviceInterface.getOperations()), args);
                }
                catch (InvocationTargetException e) {
                    final Throwable cause = e.getCause();
                    for (Class<?> declaredType : method.getExceptionTypes()) {
                        if (!declaredType.isInstance(cause)) continue;
                        throw e;
                    }
                    if (cause.getCause() != null) {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                Field field = Throwable.class.getDeclaredField("cause");
                                field.setAccessible(true);
                                field.set(cause, null);
                                field.setAccessible(false);
                                return null;
                            }
                        });
                    }
                    throw cause;
                }
            }
        });
        Class<?> targetJavaInterface = this.getTargetJavaClass(serviceInterface);
        if (!Remote.class.isAssignableFrom(targetJavaInterface)) {
            RMIServiceClassLoader classloader = new RMIServiceClassLoader(targetJavaInterface.getClassLoader());
            byte[] byteCode = this.generateRemoteInterface(targetJavaInterface);
            targetJavaInterface = classloader.defineClass(targetJavaInterface.getName(), byteCode);
            enhancer.setClassLoader((ClassLoader)classloader);
        }
        enhancer.setInterfaces(new Class[]{targetJavaInterface});
        return (Remote)enhancer.create();
    }

    protected Object invokeTarget(Operation op, Object[] args) throws InvocationTargetException {
        return this.wire.invoke(op, args);
    }

    protected byte[] generateRemoteInterface(Class serviceInterface) {
        Method[] methods;
        String interfazeName = serviceInterface.getName();
        ClassWriter cw = new ClassWriter(false);
        String simpleName = serviceInterface.getSimpleName();
        cw.visit(49, 1537, interfazeName.replace('.', '/'), "java/lang/Object", new String[]{"java/rmi/Remote"}, simpleName + ".java");
        StringBuffer argsAndReturn = null;
        for (Method method : methods = serviceInterface.getMethods()) {
            argsAndReturn = new StringBuffer("(");
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            for (Class<?> paramType : paramTypes) {
                argsAndReturn.append(Type.getType(paramType));
            }
            argsAndReturn.append(")");
            argsAndReturn.append(Type.getType(returnType));
            cw.visitMethod(1025, method.getName(), argsAndReturn.toString(), new String[]{"java/rmi/RemoteException"}, null);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected Class<?> getTargetJavaClass(Interface targetInterface) {
        return ((JavaInterface)targetInterface).getJavaClass();
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RMIServiceClassLoader
    extends ClassLoader {
        public RMIServiceClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] byteArray) {
            return super.defineClass(name, byteArray, 0, byteArray.length);
        }
    }
}

