/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rmi.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import org.apache.tuscany.sca.host.rmi.RMIHost;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class RMIReferenceInvoker
implements Invoker,
DataExchangeSemantics {
    private RMIHost rmiHost;
    private String host;
    private String port;
    private String svcName;
    private Method remoteMethod;
    private Remote proxy;

    public RMIReferenceInvoker(RMIHost rmiHost, String host, String port, String svcName, Method remoteMethod) {
        this.rmiHost = rmiHost;
        this.remoteMethod = remoteMethod;
        this.host = host;
        this.port = port;
        this.svcName = svcName;
    }

    public Message invoke(Message msg) {
        try {
            Object[] args = (Object[])msg.getBody();
            Object resp = this.invokeTarget(args);
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            msg.setFaultBody(e.getCause());
        }
        catch (Throwable e) {
            msg.setFaultBody(e);
        }
        return msg;
    }

    public Object invokeTarget(Object payload) throws InvocationTargetException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        if (this.proxy == null) {
            this.proxy = this.rmiHost.findService(this.host, this.port, this.svcName);
        }
        this.remoteMethod = this.proxy.getClass().getMethod(this.remoteMethod.getName(), this.remoteMethod.getParameterTypes());
        if (payload != null && !payload.getClass().isArray()) {
            return this.remoteMethod.invoke((Object)this.proxy, payload);
        }
        return this.remoteMethod.invoke((Object)this.proxy, (Object[])payload);
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

