/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    public static final String Notification_Source = "notification-source";
    public static final String Notification_Target = "notification-target";
    public static final String Notification_Operation = "notification-operation";
    public static final int DEF_BLOCK_SIZE = 512;

    public static Object sendHttpRequest(URL targetURL, String opName, Writeable wbody, ReadableContinuation rcont) throws Exception {
        if (opName == null) {
            opName = "";
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Notification_Operation, opName);
        return IOUtils.sendHttpRequest(targetURL, headers, wbody, rcont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object sendHttpRequest(URL targetURL, Map<String, String> headers, Writeable wbody, ReadableContinuation rcont) throws Exception {
        String targetUri = targetURL.toString();
        String sourceUri = "";
        HttpURLConnection con = (HttpURLConnection)targetURL.openConnection();
        con.setRequestMethod("POST");
        con.setAllowUserInteraction(false);
        con.setInstanceFollowRedirects(false);
        if (targetUri != null) {
            con.setRequestProperty(Notification_Target, targetUri);
        }
        if (sourceUri != null) {
            con.setRequestProperty(Notification_Source, sourceUri);
        }
        for (String key : headers.keySet()) {
            con.setRequestProperty(key, headers.get(key));
        }
        con.setDoOutput(true);
        con.setDoInput(true);
        con.connect();
        Object response = null;
        try {
            if (wbody == null) {
                throw new IOUtilsException("Missing writeable body");
            }
            OutputStream ost = con.getOutputStream();
            wbody.write(ost);
            int rc = con.getResponseCode();
            switch (rc) {
                case 200: {
                    if (rcont == null) return response;
                    InputStream ist = con.getInputStream();
                    response = rcont.read(ist);
                    return response;
                }
                case 204: {
                    return response;
                }
                default: {
                    throw new RuntimeException("Unexpected response code: " + rc);
                }
            }
        }
        finally {
            con.disconnect();
        }
    }

    public static byte[] readFully(InputStream ist, int len) throws IOException {
        ByteArrayOutputStream baost = new ByteArrayOutputStream();
        IOUtils.copyStream(ist, baost, len);
        return baost.toByteArray();
    }

    public static int copyStream(InputStream ist, OutputStream ost) throws IOException {
        return IOUtils.copyStream(ist, ost, -1, 0);
    }

    public static int copyStream(InputStream ist, OutputStream ost, int length) throws IOException {
        return IOUtils.copyStream(ist, ost, length, 0);
    }

    public static int copyStream(InputStream ist, OutputStream ost, int length, int blockSize) throws IOException {
        boolean done;
        int cbCopied = 0;
        if (blockSize <= 0) {
            blockSize = 512;
        }
        byte[] block = new byte[blockSize];
        boolean bl = done = length == 0;
        while (!done) {
            try {
                int cbToRead = length == -1 ? block.length : Math.min(length - cbCopied, block.length);
                int cbRead = ist.read(block, 0, cbToRead);
                if (cbRead == -1) {
                    done = true;
                    continue;
                }
                ost.write(block, 0, cbRead);
                done = (cbCopied += cbRead) == length;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        ost.flush();
        return cbCopied;
    }

    public static class IOUtilsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IOUtilsException(String message) {
            super(message);
        }

        public IOUtilsException(Throwable cause) {
            super(cause);
        }
    }

    public static interface ReadableContinuation {
        public Object read(InputStream var1) throws IOUtilsException;
    }

    public static interface Writeable {
        public void write(OutputStream var1) throws IOUtilsException;
    }
}

