/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerConsumerReference;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.NeighborBrokerConsumers;
import org.apache.tuscany.sca.binding.notification.encoding.RemoveBroker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveBrokerEnDeCoder
extends AbstractEnDeCoder<RemoveBroker> {
    public static final QName QNAME = new QName("http://docs.oasis-open.org/wsn/b-2", "RemoveBroker");

    public RemoveBrokerEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(RemoveBroker encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            writer.writeStartElement("wsnt", QNAME.getLocalPart(), QNAME.getNamespaceURI());
            writer.writeNamespace("wsnt", QNAME.getNamespaceURI());
            this.registry.encode(encodingObject.getBrokerConsumerReference(), writer);
            if (encodingObject.getNeighborBrokerConsumers() != null) {
                this.registry.encode(encodingObject.getNeighborBrokerConsumers(), writer);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public RemoveBroker decode(XMLStreamReader reader) throws EncodingException {
        try {
            RemoveBroker removeBrokerElement = new RemoveBroker();
            boolean haveBCR = false;
            boolean haveNBC = false;
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        EncodingObject encodingObject = this.registry.decode(reader);
                        if (encodingObject instanceof BrokerConsumerReference && !haveBCR) {
                            removeBrokerElement.setBrokerConsumerReference((BrokerConsumerReference)encodingObject);
                            haveBCR = true;
                            break;
                        }
                        if (encodingObject instanceof NeighborBrokerConsumers && !haveNBC) {
                            removeBrokerElement.setNeighborBrokerConsumers((NeighborBrokerConsumers)encodingObject);
                            haveNBC = true;
                            break;
                        }
                        throw new EncodingException("Invalid encoding object");
                    }
                    case 2: {
                        if (!haveBCR) {
                            throw new EncodingException("Missing broker consumer reference");
                        }
                        return removeBrokerElement;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new EncodingException(ex);
        }
    }

    @Override
    public QName getEncodingObjectQName() {
        return QNAME;
    }

    @Override
    public Class<RemoveBroker> getEncodingObjectType() {
        return RemoveBroker.class;
    }
}

