/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.Broker;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.Neighbors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborsEnDeCoder
extends AbstractEnDeCoder<Neighbors> {
    public static final QName QNAME = new QName("http://docs.oasis-open.org/wsn/b-2", "Neighbors");

    public NeighborsEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(Neighbors encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            QName qName = this.getEncodingObjectQName();
            writer.writeStartElement("wsnt", qName.getLocalPart(), qName.getNamespaceURI());
            writer.writeNamespace("wsnt", qName.getNamespaceURI());
            if (encodingObject.getBrokerSequence() != null) {
                for (Broker broker : encodingObject.getBrokerSequence()) {
                    this.registry.encode(broker, writer);
                }
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public Neighbors decode(XMLStreamReader reader) throws EncodingException {
        try {
            Neighbors neighborsElement = new Neighbors();
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        EncodingObject encodingObject = this.registry.decode(reader);
                        neighborsElement.addBrokerToSequence((Broker)encodingObject);
                        break;
                    }
                    case 2: {
                        return neighborsElement;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new EncodingException(ex);
        }
    }

    @Override
    public QName getEncodingObjectQName() {
        return QNAME;
    }

    @Override
    public Class<Neighbors> getEncodingObjectType() {
        return Neighbors.class;
    }
}

