/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReference;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReferenceSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndpointReferenceSequenceEnDeCoder<ERS extends EndpointReferenceSequence>
extends AbstractEnDeCoder<ERS> {
    public EndpointReferenceSequenceEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(ERS encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            QName qName = this.getEncodingObjectQName();
            writer.writeStartElement("wsnt", qName.getLocalPart(), qName.getNamespaceURI());
            writer.writeNamespace("wsnt", qName.getNamespaceURI());
            this.encodeSequenceTypeAttribute(encodingObject, writer);
            if (((EndpointReferenceSequence)encodingObject).getReferenceSequence() != null) {
                for (EndpointReference endpointReference : ((EndpointReferenceSequence)encodingObject).getReferenceSequence()) {
                    this.registry.encode(endpointReference, writer);
                }
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    protected abstract void encodeSequenceTypeAttribute(ERS var1, XMLStreamWriter var2) throws EncodingException;

    @Override
    public ERS decode(XMLStreamReader reader) throws EncodingException {
        try {
            EndpointReferenceSequence endpointReferenceSequenceElement = null;
            try {
                endpointReferenceSequenceElement = (EndpointReferenceSequence)this.getEncodingObjectType().newInstance();
            }
            catch (Exception e) {
                throw new EncodingException(e);
            }
            String sequenceType = this.decodeSequenceTypeAttribute(reader);
            endpointReferenceSequenceElement.setSequenceType(sequenceType);
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        EncodingObject encodingObject = this.registry.decode(reader);
                        endpointReferenceSequenceElement.addReferenceToSequence((EndpointReference)encodingObject);
                        break;
                    }
                    case 2: {
                        return (ERS)endpointReferenceSequenceElement;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new EncodingException(ex);
        }
    }

    protected abstract String decodeSequenceTypeAttribute(XMLStreamReader var1);
}

