/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointAddress;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReference;
import org.apache.tuscany.sca.binding.notification.encoding.ReferenceProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReferenceEnDeCoder
extends AbstractEnDeCoder<EndpointReference> {
    public static final QName QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference");

    public EndpointReferenceEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(EndpointReference encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            writer.writeStartElement("wsa", QNAME.getLocalPart(), QNAME.getNamespaceURI());
            writer.writeNamespace("wsa", QNAME.getNamespaceURI());
            this.registry.encode(encodingObject.getEndpointAddress(), writer);
            if (encodingObject.getReferenceProperties() != null) {
                this.registry.encode(encodingObject.getReferenceProperties(), writer);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public EndpointReference decode(XMLStreamReader reader) throws EncodingException {
        try {
            EndpointReference endpointReferenceElement = new EndpointReference();
            boolean haveEPA = false;
            boolean haveRP = false;
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        EncodingObject encodingObject = this.registry.decode(reader);
                        if (encodingObject instanceof EndpointAddress && !haveEPA) {
                            endpointReferenceElement.setEndpointAddress((EndpointAddress)encodingObject);
                            haveEPA = true;
                            break;
                        }
                        if (encodingObject instanceof ReferenceProperties && !haveRP) {
                            endpointReferenceElement.setReferenceProperties((ReferenceProperties)encodingObject);
                            haveRP = true;
                            break;
                        }
                        throw new EncodingException("Invalid encoding object");
                    }
                    case 2: {
                        if (!haveEPA) {
                            throw new EncodingException("Missing endpoint address");
                        }
                        return endpointReferenceElement;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new EncodingException(ex);
        }
    }

    @Override
    public QName getEncodingObjectQName() {
        return QNAME;
    }

    @Override
    public Class<EndpointReference> getEncodingObjectType() {
        return EndpointReference.class;
    }
}

