/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerID;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerIDEnDeCoder
extends AbstractEnDeCoder<BrokerID> {
    public static final QName QNAME = new QName("http://docs.oasis-open.org/wsn/b-2", "BrokerID");

    public BrokerIDEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(BrokerID encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            writer.writeStartElement("wsnt", QNAME.getLocalPart(), QNAME.getNamespaceURI());
            writer.writeNamespace("wsnt", QNAME.getNamespaceURI());
            writer.writeCharacters(encodingObject.getID());
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public BrokerID decode(XMLStreamReader reader) throws EncodingException {
        try {
            BrokerID brokerIDElement = new BrokerID();
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        if (reader.hasText()) {
                            String id = reader.getText();
                            brokerIDElement.setID(id);
                            break;
                        }
                        throw new EncodingException("Broker ID missing value");
                    }
                    case 2: {
                        return brokerIDElement;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new EncodingException(ex);
        }
    }

    @Override
    public QName getEncodingObjectQName() {
        return QNAME;
    }

    @Override
    public Class<BrokerID> getEncodingObjectType() {
        return BrokerID.class;
    }
}

