/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.tuscany.sca.binding.notification.NotificationBinding;
import org.apache.tuscany.sca.binding.notification.NotificationBrokerManager;
import org.apache.tuscany.sca.binding.notification.NotificationTypeManager;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerConsumerReference;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerID;
import org.apache.tuscany.sca.binding.notification.encoding.ConnectionOverride;
import org.apache.tuscany.sca.binding.notification.encoding.ConsumerReference;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingUtils;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointAddress;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReference;
import org.apache.tuscany.sca.binding.notification.encoding.ReferenceProperties;
import org.apache.tuscany.sca.binding.notification.encoding.Subscribe;
import org.apache.tuscany.sca.binding.notification.util.IOUtils;
import org.apache.tuscany.sca.binding.notification.util.NotificationServlet;
import org.apache.tuscany.sca.binding.notification.util.URIUtil;
import org.apache.tuscany.sca.core.invocation.MessageImpl;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationServiceBindingProvider
implements ServiceBindingProvider,
NotificationServlet.NotificationServletStreamHandler {
    private RuntimeWire wire;
    private NotificationBinding notificationBinding;
    private RuntimeComponentService service;
    private ServletHost servletHost;
    private NotificationTypeManager ntm;
    private EncodingRegistry encodingRegistry;
    private URI notificationType;
    private URL myUrl;
    private URL remoteNtmUrl;
    private static final String consumerPathBase = "/consumer";
    private boolean started;
    private NotificationBrokerManager brokerManager;
    private String brokerID;

    public NotificationServiceBindingProvider(NotificationBinding notificationBinding, RuntimeComponent component, RuntimeComponentService service, ServletHost servletHost, NotificationTypeManager ntm, EncodingRegistry encodingRegistry, String httpUrl, NotificationBrokerManager brokerManager) {
        this.notificationBinding = notificationBinding;
        this.service = service;
        this.servletHost = servletHost;
        this.ntm = ntm;
        this.encodingRegistry = encodingRegistry;
        this.notificationType = notificationBinding.getNotificationType();
        String ntmAddress = notificationBinding.getNtmAddress();
        String notificationTypePath = URIUtil.getPath(this.notificationType);
        try {
            this.myUrl = new URL(httpUrl + consumerPathBase + notificationTypePath);
            this.remoteNtmUrl = null;
            if (ntmAddress != null && this.notificationType != null) {
                this.remoteNtmUrl = new URL(ntmAddress + notificationTypePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.started = false;
        this.brokerManager = brokerManager;
        this.brokerID = null;
        URI uri = URI.create(component.getURI() + "/" + notificationBinding.getName());
        notificationBinding.setURI(uri.toString());
        Interface interfaze = service.getInterfaceContract().getInterface();
        interfaze.resetDataBinding(OMElement.class.getName());
        for (Operation operation : interfaze.getOperations()) {
            operation.setNonBlocking(false);
        }
    }

    public NotificationBinding getBinding() {
        return this.notificationBinding;
    }

    public boolean isStarted() {
        return this.started;
    }

    public URL getURL() {
        return this.myUrl;
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        RuntimeComponentService componentService = this.service;
        this.wire = componentService.getRuntimeWire(this.notificationBinding);
        for (InvocationChain ch : this.wire.getInvocationChains()) {
            ch.setAllowsPassByReference(true);
        }
        this.brokerManager.serviceProviderStarted(this.notificationType, this, this.remoteNtmUrl);
        this.started = true;
    }

    @Override
    public void stop() {
    }

    public void deployConsumer() {
        WriteableSubscribe ws = new WriteableSubscribe(this.myUrl, null);
        ArrayList<URL> producerList = new ArrayList<URL>();
        String sequenceType = this.ntm.newConsumer(this.notificationType, this.myUrl, this.remoteNtmUrl, producerList);
        if ("EndProducers".equals(sequenceType)) {
            for (URL producerUrl : producerList) {
                this.subscribeWithProducer(producerUrl, null, ws);
            }
        } else if ("BrokerProducers".equals(sequenceType)) {
            URL producerUrl = (URL)producerList.get(0);
            this.subscribeWithProducer(producerUrl, null, ws);
        }
        this.servletHost.addServletMapping(this.myUrl.toString(), (Servlet)new NotificationServlet(this));
    }

    protected void subscribeWithProducer(URL producerUrl, String brokerID, WriteableSubscribe ws) {
        if (ws == null) {
            ws = new WriteableSubscribe(this.myUrl, brokerID);
        }
        try {
            IOUtils.sendHttpRequest(producerUrl, "subscribe", (IOUtils.Writeable)ws, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deployBroker(String brokerID, EndpointReference brokerProducerEPR, List<EndpointReference> producerList) {
        if (brokerProducerEPR != null) {
            this.subscribeWithProducer(brokerProducerEPR.getEndpointAddress().getAddress(), brokerID, null);
        }
        this.brokerID = brokerID;
        if (producerList != null && !producerList.isEmpty()) {
            WriteableConnectionOverride wco = new WriteableConnectionOverride(this.myUrl, brokerID);
            for (EndpointReference producerEPR : producerList) {
                try {
                    IOUtils.sendHttpRequest(producerEPR.getEndpointAddress().getAddress(), "connectionOverride", (IOUtils.Writeable)wco, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.servletHost.addServletMapping(this.myUrl.toString(), (Servlet)new NotificationServlet(this));
    }

    public void replaceBrokerConnection(EndpointReference chosenBrokerProducerEpr) {
        if (this.brokerID == null) {
            throw new RuntimeException("Missing broker id");
        }
        URL producerUrl = chosenBrokerProducerEpr.getEndpointAddress().getAddress();
        this.subscribeWithProducer(producerUrl, this.brokerID, null);
    }

    @Override
    public void handle(Map<String, String> headers, ServletInputStream istream, int contentLength, ServletOutputStream ostream) {
        String opHeader = headers.get("notification-operation");
        String incomingBrokerID = headers.get("brokerID");
        if (opHeader == null) {
            throw new RuntimeException("Missing operation header");
        }
        if (this.wire == null) {
            throw new RuntimeException("Missing wire");
        }
        InvocationChain chain = null;
        for (InvocationChain ch : this.wire.getInvocationChains()) {
            if (!ch.getTargetOperation().getName().equals(opHeader)) continue;
            chain = ch;
            break;
        }
        if (chain == null) {
            throw new RuntimeException("Can't find invocation chain match for [" + opHeader + "]");
        }
        byte[] payload = null;
        try {
            payload = IOUtils.readFully((InputStream)istream, contentLength);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object[] args = this.getArgsFromByteArray(payload, incomingBrokerID);
        this.invoke(chain, args);
    }

    private Object[] getArgsFromByteArray(byte[] payload, String incomingBrokerID) {
        try {
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(payload));
            OMElement element = builder.getDocumentElement();
            return new Object[]{element};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void invoke(InvocationChain chain, Object[] args) {
        MessageImpl msg = new MessageImpl();
        msg.setBody(args);
        chain.getHeadInvoker().invoke(msg);
    }

    class WriteableConnectionOverride
    implements IOUtils.Writeable {
        private ConnectionOverride connectionOverride;

        public WriteableConnectionOverride(URL brokerConsumerUrl, String brokerID) {
            EndpointAddress epa = new EndpointAddress();
            epa.setAddress(brokerConsumerUrl);
            EndpointReference brokerConsumerEPR = new EndpointReference();
            brokerConsumerEPR.setEndpointAddress(epa);
            BrokerID cbi = new BrokerID();
            cbi.setID(brokerID);
            ReferenceProperties crp = new ReferenceProperties();
            crp.addProperty(cbi);
            brokerConsumerEPR.setReferenceProperties(crp);
            BrokerConsumerReference brokerConsumerReference = new BrokerConsumerReference();
            brokerConsumerReference.setReference(brokerConsumerEPR);
            this.connectionOverride = new ConnectionOverride();
            this.connectionOverride.setBrokerConsumerReference(brokerConsumerReference);
        }

        public void write(OutputStream os) throws IOUtils.IOUtilsException {
            EncodingUtils.encodeToStream(NotificationServiceBindingProvider.this.encodingRegistry, this.connectionOverride, os);
        }
    }

    class WriteableSubscribe
    implements IOUtils.Writeable {
        private Subscribe sub;

        public WriteableSubscribe(URL url, String brokerID) {
            EndpointAddress epa = new EndpointAddress();
            epa.setAddress(url);
            EndpointReference epr = new EndpointReference();
            epr.setEndpointAddress(epa);
            if (brokerID != null) {
                BrokerID cbi = new BrokerID();
                cbi.setID(brokerID);
                ReferenceProperties crp = new ReferenceProperties();
                crp.addProperty(cbi);
                epr.setReferenceProperties(crp);
            }
            ConsumerReference cr = new ConsumerReference();
            cr.setReference(epr);
            this.sub = new Subscribe();
            this.sub.setConsumerReference(cr);
        }

        public void write(OutputStream os) throws IOUtils.IOUtilsException {
            EncodingUtils.encodeToStream(NotificationServiceBindingProvider.this.encodingRegistry, this.sub, os);
        }
    }
}

