/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.binding.notification.NotificationBinding;
import org.apache.tuscany.sca.binding.notification.NotificationBrokerManager;
import org.apache.tuscany.sca.binding.notification.NotificationReferenceBindingInvoker;
import org.apache.tuscany.sca.binding.notification.NotificationTypeManager;
import org.apache.tuscany.sca.binding.notification.encoding.Broker;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerID;
import org.apache.tuscany.sca.binding.notification.encoding.ConnectionOverride;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingUtils;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReference;
import org.apache.tuscany.sca.binding.notification.encoding.ReplaceBrokerConnection;
import org.apache.tuscany.sca.binding.notification.encoding.Subscribe;
import org.apache.tuscany.sca.binding.notification.util.NotificationServlet;
import org.apache.tuscany.sca.binding.notification.util.URIUtil;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationReferenceBindingProvider
implements ReferenceBindingProvider,
NotificationServlet.NotificationServletStreamHandler {
    private static final String producerPathBase = "/producer";
    private NotificationReferenceBindingInvoker invoker = null;
    private RuntimeComponentReference reference;
    private NotificationBinding notificationBinding;
    private ServletHost servletHost;
    private NotificationTypeManager ntm;
    private EncodingRegistry encodingRegistry;
    private URI notificationType;
    private URL myUrl;
    private URL remoteNtmUrl;
    private boolean started;
    private NotificationBrokerManager brokerManager;
    private List<SubscriberInfo> subscribers;
    private String brokerID;

    public NotificationReferenceBindingProvider(NotificationBinding notificationBinding, RuntimeComponent component, RuntimeComponentReference reference, ServletHost servletHost, NotificationTypeManager ntm, EncodingRegistry encodingRegistry, String httpUrl, NotificationBrokerManager brokerManager) {
        this.notificationBinding = notificationBinding;
        this.reference = reference;
        this.servletHost = servletHost;
        this.ntm = ntm;
        this.encodingRegistry = encodingRegistry;
        this.notificationType = notificationBinding.getNotificationType();
        String ntmAddress = notificationBinding.getNtmAddress();
        String notificationTypePath = URIUtil.getPath(this.notificationType);
        try {
            this.myUrl = new URL(httpUrl + producerPathBase + notificationTypePath);
            this.remoteNtmUrl = null;
            if (ntmAddress != null && this.notificationType != null) {
                this.remoteNtmUrl = new URL(ntmAddress + notificationTypePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.started = false;
        this.brokerManager = brokerManager;
        URI uri = URI.create(component.getURI() + "/" + notificationBinding.getName());
        notificationBinding.setURI(uri.toString());
        Interface interfaze = reference.getInterfaceContract().getInterface();
        interfaze.resetDataBinding(OMElement.class.getName());
        for (Operation operation : interfaze.getOperations()) {
            operation.setNonBlocking(false);
        }
        this.subscribers = new ArrayList<SubscriberInfo>();
        this.brokerID = null;
    }

    public NotificationBinding getBinding() {
        return this.notificationBinding;
    }

    public URL getURL() {
        return this.myUrl;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setBrokerID(String brokerID) {
        this.brokerID = brokerID;
    }

    public String getBrokerID() {
        return this.brokerID;
    }

    @Override
    public Invoker createInvoker(Operation operation) {
        if (this.invoker == null) {
            this.invoker = new NotificationReferenceBindingInvoker(operation, this);
        }
        return this.invoker;
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.brokerManager.referenceProviderStarted(this.notificationType, this, this.remoteNtmUrl);
        this.started = true;
    }

    @Override
    public void stop() {
    }

    public void deployProducer() {
        String sequenceType;
        ArrayList<URL> consumerList = new ArrayList<URL>();
        try {
            sequenceType = this.ntm.newProducer(this.notificationType, this.myUrl, this.remoteNtmUrl, consumerList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if ("EndConsumers".equals(sequenceType)) {
            for (URL consumerUrl : consumerList) {
                this.addSubscriberUrl(consumerUrl);
            }
        } else if ("BrokerConsumers".equals(sequenceType)) {
            URL consumerUrl = (URL)consumerList.get(0);
            this.addSubscriberUrl(consumerUrl);
        }
        this.servletHost.addServletMapping(this.myUrl.toString(), (Servlet)new NotificationServlet(this));
    }

    public void deployBroker(String brokerID, EndpointReference brokerConsumerEPR, List<EndpointReference> consumerList) {
        if (brokerConsumerEPR != null) {
            this.addSubscriber(brokerConsumerEPR);
        }
        if (consumerList != null && !consumerList.isEmpty()) {
            for (EndpointReference consumerEPR : consumerList) {
                this.addSubscriber(consumerEPR);
            }
        }
        this.setBrokerID(brokerID);
        this.servletHost.addServletMapping(this.myUrl.toString(), (Servlet)new NotificationServlet(this));
    }

    public void undeployBroker(URL brokerConsumerUrl) {
        EndpointReference brokerConsumerEpr = EncodingUtils.createEndpointReference(brokerConsumerUrl, this.getBrokerID());
        this.ntm.removeBroker(brokerConsumerEpr, this.getNeighborBrokerConsumerEprs(), this.remoteNtmUrl);
        this.removeBrokerSubscribers();
    }

    @Override
    public void handle(Map<String, String> headers, ServletInputStream istream, int contentLength, ServletOutputStream ostream) {
        block7: {
            try {
                EncodingObject eo = EncodingUtils.decodeFromStream(this.encodingRegistry, (InputStream)istream);
                if (eo instanceof Subscribe) {
                    Subscribe sub = (Subscribe)eo;
                    this.addSubscriber(sub.getConsumerReference().getReference());
                    break block7;
                }
                if (eo instanceof ConnectionOverride) {
                    ConnectionOverride co = (ConnectionOverride)eo;
                    this.replaceSubscribers(co.getBrokerConsumerReference().getReference());
                    break block7;
                }
                if (eo instanceof ReplaceBrokerConnection) {
                    ReplaceBrokerConnection rbc = (ReplaceBrokerConnection)eo;
                    URL removedBrokerConsumerEpr = rbc.getRemovedBroker().getReference().getEndpointAddress().getAddress();
                    if (rbc.getNeighbors() != null) {
                        int choice = rbc.getNeighbors().getBrokerSequence().size() - 1;
                        Broker chosenBroker = rbc.getNeighbors().getBrokerSequence().get(choice);
                        this.replaceBrokerSubscriber(removedBrokerConsumerEpr, chosenBroker.getBrokerConsumerReference().getReference());
                        this.brokerManager.replaceConsumersBrokerConnection(this.notificationType, chosenBroker.getBrokerProducerReference().getReference());
                    } else {
                        this.replaceBrokerSubscriber(removedBrokerConsumerEpr, null);
                    }
                    break block7;
                }
                throw new RuntimeException("Unknown encoding object");
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized List<SubscriberInfo> getSubscribers() {
        return this.subscribers;
    }

    private void addSubscriberUrl(URL subscriberUrl) {
        this.addSubscriber(subscriberUrl, null);
    }

    private void addSubscriber(EndpointReference subscriberEPR) {
        BrokerID brokerID = null;
        if (subscriberEPR.getReferenceProperties() != null) {
            brokerID = subscriberEPR.getReferenceProperties().getProperty(BrokerID.class);
        }
        this.addSubscriber(subscriberEPR.getEndpointAddress().getAddress(), brokerID != null ? brokerID.getID() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubscriber(URL address, String brokerID) {
        NotificationReferenceBindingProvider notificationReferenceBindingProvider = this;
        synchronized (notificationReferenceBindingProvider) {
            SubscriberInfo si = new SubscriberInfo(address);
            si.brokerID = brokerID;
            if (this.subscribers == null) {
                this.subscribers = new ArrayList<SubscriberInfo>();
            }
            this.subscribers.add(si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSubscribers(EndpointReference brokerConsumerEPR) {
        NotificationReferenceBindingProvider notificationReferenceBindingProvider = this;
        synchronized (notificationReferenceBindingProvider) {
            this.subscribers = null;
        }
        this.addSubscriber(brokerConsumerEPR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceBrokerSubscriber(URL removedBrokerConsumerUrl, EndpointReference chosenBrokerConsumerEpr) {
        NotificationReferenceBindingProvider notificationReferenceBindingProvider = this;
        synchronized (notificationReferenceBindingProvider) {
            if (this.subscribers == null) {
                throw new RuntimeException("No subscribers");
            }
            SubscriberInfo siToRemove = null;
            for (SubscriberInfo si : this.subscribers) {
                if (!si.address.equals(removedBrokerConsumerUrl)) continue;
                siToRemove = si;
            }
            if (siToRemove == null) {
                throw new RuntimeException("Can't find info for broker to remove [" + removedBrokerConsumerUrl + "]");
            }
            if (!this.subscribers.remove(siToRemove)) {
                throw new RuntimeException("Can't remove info for [" + siToRemove.address + "]");
            }
        }
        if (chosenBrokerConsumerEpr != null) {
            this.addSubscriber(chosenBrokerConsumerEpr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EndpointReference> getNeighborBrokerConsumerEprs() {
        NotificationReferenceBindingProvider notificationReferenceBindingProvider = this;
        synchronized (notificationReferenceBindingProvider) {
            if (this.subscribers == null) {
                throw new RuntimeException("No subscribers");
            }
            ArrayList<EndpointReference> neighborBrokerConsumerEprs = new ArrayList<EndpointReference>();
            for (SubscriberInfo si : this.subscribers) {
                if (si.brokerID == null) continue;
                neighborBrokerConsumerEprs.add(EncodingUtils.createEndpointReference(si.address, si.brokerID));
            }
            return neighborBrokerConsumerEprs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBrokerSubscribers() {
        NotificationReferenceBindingProvider notificationReferenceBindingProvider = this;
        synchronized (notificationReferenceBindingProvider) {
            if (this.subscribers == null) {
                throw new RuntimeException("No subscribers");
            }
            ArrayList<SubscriberInfo> sisToRemove = new ArrayList<SubscriberInfo>();
            for (SubscriberInfo si : this.subscribers) {
                if (si.brokerID == null) continue;
                sisToRemove.add(si);
            }
            for (SubscriberInfo si : sisToRemove) {
                if (this.subscribers.remove(si)) continue;
                throw new RuntimeException("Can't remove broker subscriber [" + si.address + "]");
            }
        }
    }

    class SubscriberInfo {
        public URL address;
        public String brokerID;

        public SubscriberInfo(URL address) {
            this.address = address;
            this.brokerID = null;
        }
    }
}

